package com.digiwin.athena.gmc.sdk.manager;

import com.alibaba.fastjson.JSONArray;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import com.digiwin.athena.gmc.sdk.meta.dto.GmcResultDTO;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.meta.function.JaFunctionRP;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;

import java.util.HashMap;
import java.util.Map;

/**
 * eoc 通用api
 *
 * @author gengwei
 * @since 2024/8/20 10:18
 */
public class GmcManager {

    public static final String IAM_USER_TOKEN = "digi-middleware-auth-user";

    public static final String IAM_APP_TOKEN = "digi-middleware-auth-app";

    public static final String IAM_APP_TOKEN_ATHENA = "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c";

    private static String getGmcUri() {
        return JaProperty.get("gmc.uri");
    }


    private static final ParameterizedTypeReference<GmcResultDTO<JSONArray>> JSONArrayType = new ParameterizedTypeReference<GmcResultDTO<JSONArray>>() {
    };

    /**
     * 通过appcode获取钉钉suiteKey
     */
    public static final String GMC_GOODS_MAPPINGS_URL = getGmcUri() + "/api/gmc/v2/goods/mappings?code={code}";


    public static GmcResultDTO<JSONArray> queryAppAuthInfo(AuthoredUser user, String appCode) {
        JaFunctionRP<HttpHeaders, HttpHeaders> jaFunction = (headers) -> {
            headers.set(IAM_USER_TOKEN, user.getToken());
            headers.set(IAM_APP_TOKEN, IAM_APP_TOKEN_ATHENA);
            return headers;
        };
        Map<String, Object> param = new HashMap<>();
        param.put("code", appCode);
        return DwSpringHttpUtil.get(GMC_GOODS_MAPPINGS_URL, JSONArrayType, jaFunction, param);
    }


}
