package com.digiwin.athena.manager.iam.sdk;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.manager.common.util.DwAHttpUtil;
import com.jugg.agile.framework.core.config.JaProperty;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpHeaders;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

/**
 * iam api
 *
 * @author gengwei
 * @since 2024/8/15 11:48
 */
@Slf4j
public class IamApi {

    private static String getIamUri() {
        return JaProperty.get("iam.uri");
    }

    public static JSONObject queryApiVirtualToken(String tenantId) {
        //查询租户虚拟tokenUrl
        String uri = getIamUri() + IamConstant.IDENTITY_LOGIN_INTERNAL;

        Function<HttpHeaders, HttpHeaders> headersFunction = headers -> {
            headers.add("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
            return headers;
        };

        Map<String, String> param = new HashMap<>();
        param.put("tenantId", tenantId);
        param.put("userId", "integration");
        param.put("passwordHash", "6826CC688C4AF1BD0A8DDA2DBDF8897B");
        JSONObject result = DwAHttpUtil.post(uri, param, JSONObject.class, headersFunction);

        if (null == result) {
            log.error("this tenant :{}return none virtual token.", tenantId);
            return new JSONObject();
        }
        return result;

    }
}
