package com.digiwin.athena.manager.iam.sdk;

/**
 * iam 相关常量
 *
 * @author gengwei
 * @date 2024/8/15 11:46
 **/
public interface IamConstant {

    /**
     * 检查
     */
    String USERS_CHECK_USER_TENANT_AUTH = "/api/boss/v1/users/check/user/tenant/auth?tenantId={tenantId}&appId={appId}&email={email}";


    /**
     * 将用户添加到企业用户中
     */
    String USERS_ENTERPRISE = "/api/boss/v1/users/enterprise";

    /**
     * 根据邮箱获取个人租户
     * status的值
     * -1 调用接口失败
     * 0 没有个人租户
     * 1 没有授权
     * 2 有个人租户并且有授权
     */
    String USER_EMAIL_TENANTS_AUTH = "/api/iam/v2/user/email/tenants/auth";

    /**
     * 创建个人租户以及授权
     */
    String USER_INDIVIDUAL_TENANT_REGISTER = "/api/iam/v2/user/individual/tenant/register";

    /**
     * 给指定租户下的用户授权指定应用
     */
    String USER_TENANT_USER_AUTH = "/api/iam/v2/user/tenant/user/auth";

    /**
     * 登陆
     */
    String IDENTITY_LOGIN = "/api/iam/v2/identity/login";

    /**
     * 根据用户id获取角色信息
     */
    String USER_ROLE = "/api/iam/v2/user/role";

    /**
     * 根据角色id获取角色信息
     */
    String ROLE = "/api/iam/v2/role";

    /**
     * 测试租户
     */
    String TENANT_SIMPLE = "/api/iam/v2/tenant/simple";

    /**
     * 根据租户id，名称或者统编号查询租户信息
     */
    String TENANT_RELEVANTINFO = "/api/iam/v2/tenant/relevantinfo?tenantContent={content}&unifiedTaxationCode={taxNo}";

    /**
     * 获取租户简单信息
     */
    String TENANT_SIMPLES = "/api/iam/v2/tenant/simples";

    /**
     * 从api中获取租户的虚拟token
     */
    String IDENTITY_LOGIN_INTERNAL = "/api/iam/v2/identity/login/internal";

    /**
     * 根据用户id获取用户相关的信息
     */
    String USER = "/api/iam/v2/user/full";

    /**
     * 根据邮箱获取任务的实际执行人
     */
    String USER_EMAIL = "/api/iam/v2/user/email";

    /**
     * 根据用户phone和租户Id获取用户相关的信息
     */
    String USER_TELEPHONE = "/api/iam/v2/user/telephone";

    /**
     * 根据归户信息获取用户相关的信息
     */
    String MAPPING_QUERY_QPPUSER = "/api/iam/v2/mapping/query/appuser";

    /**
     * 通过用户ID 获取是否静默
     */
    String USER_METADATA_VALUE = "/api/iam/v2/user/metadata/value";

    /**
     * 获取用户的偏好联系方式
     */
    String USERMETADATA_USER_ACCEPTCONTACTS_GET = "/api/iam/v2/usermetadata/user/acceptcontacts/get";

    /**
     * 获取指定用户所有租户下的元数据信息
     */
    String USERMETADATA_CURRENT = "/api/iam/v2/usermetadata/current";

    /**
     * 根据userSid获取租户语言别设置
     */
    String USERMETADATA_USER_GET = "/api/iam/v2/usermetadata/user/get";

    /**
     * 获取指定用户所有租户下的元数据信息(该方法会增加缓存处理，请注意)
     */
    String USERMETADATA_ALL = "/api/iam/v2/usermetadata/all";

    /**
     * 企業邀請用戶加入【Athena】【4.15】
     */
    String TENANT_USER_INVITE_NEW = "/api/iam/v2/tenant/user/invite/new";

    /**
     * 判断邮箱帐号是否已经注册,且是否为鼎捷用户，排除掉企业内部用户
     */
    String USER_EMAIL_WITHOUT_INNER_EXIST = "/api/iam/v2/user/email/without/inner/exist";

    /**
     * 判断手机号是否已经注册,且是否为鼎捷用户，排除掉企业内部用户
     */
    String USER_MOBILEPHONE_WITHOUT_INNER_EXIST = "/api/iam/v2/user/mobilephone/without/inner/exist";

    /**
     * 查询用户的个性化设置数据
     */
    String USERMETADATA_UPDATE = "/api/iam/v2/usermetadata/update";

    /**
     * 根据用户id查询出用户的
     */
    @Deprecated
    String USER_CONTACTS_USERID = "/api/iam/v2/user/contacts?id={userId}";

    /**
     * 获取用户的租户信息;4.11增加返回agreeAgreement
     * iam接口安全调整方案，替换/api/iam/v2/user/contacts接口;
     */
    String TENANT_INFO = "/api/iam/v2/user/withtenant";

    /**
     * 新增租户客户关系
     */
    String INVOICE_TAXNO = "/api/iam/v3/invoice/taxno/{unifyNumber}";

    /**
     * 获取内部员工
     */
    String IAM_V_2_USER_LIST = "/api/iam/v2/user/list";

    /**
     * 获取第三方平台的映射用户信息
     */
    String GMC_V_2_MAPPING_QUERY = "/api/iam/v2/mapping/query";

}
