package com.digiwin.athena.iam.sdk.manager;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.common.sdk.manager.meta.constants.DwHttpHeaderConstants;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import com.digiwin.athena.iam.sdk.meta.dto.IamResultDTO;
import com.digiwin.athena.iam.sdk.meta.dto.request.QueryPersonalizedInfoReqDTO;
import com.digiwin.athena.iam.sdk.meta.dto.request.UserEmailTenantsAuthReqDTO;
import com.digiwin.athena.iam.sdk.meta.dto.request.VirtualTokenReqDTO;
import com.digiwin.athena.iam.sdk.meta.dto.response.BossIamTenantAuthDTO;
import com.digiwin.athena.iam.sdk.meta.dto.response.InnerExistDTO;
import com.digiwin.athena.iam.sdk.meta.dto.response.PersonalizedDTO;
import com.digiwin.athena.iam.sdk.meta.dto.response.UserDTO;
import com.digiwin.athena.iam.sdk.meta.dto.response.UserRoleDTO;
import com.digiwin.athena.iam.sdk.meta.dto.response.WithTenantRespDTO;
import com.jugg.agile.framework.core.config.JaProperty;
import org.springframework.core.ParameterizedTypeReference;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * iam api
 *
 * @author gengwei
 * @since 2024/8/15 11:48
 */
public class IamManager {


    private static String getIamUri() {
        return JaProperty.get("iam.uri");
    }

    /**
     * 查询租户虚拟tokenUrl
     */
    private static final ParameterizedTypeReference<JSONObject> JSONObjectType = new ParameterizedTypeReference<JSONObject>() {
    };
    private static final ParameterizedTypeReference<List<JSONObject>> JSONObjectListType = new ParameterizedTypeReference<List<JSONObject>>() {
    };
    private static final ParameterizedTypeReference<IamResultDTO<Map<Object, Object>>> MapType = new ParameterizedTypeReference<IamResultDTO<Map<Object, Object>>>() {
    };
    private static final ParameterizedTypeReference<UserDTO> UserDTOType = new ParameterizedTypeReference<UserDTO>() {
    };
    private static final ParameterizedTypeReference<IamResultDTO<UserDTO>> IamUserDTOType = new ParameterizedTypeReference<IamResultDTO<UserDTO>>() {
    };
    private static final ParameterizedTypeReference<IamResultDTO<BossIamTenantAuthDTO>> BossIamTenantAuthDTOType = new ParameterizedTypeReference<IamResultDTO<BossIamTenantAuthDTO>>() {
    };
    private static final ParameterizedTypeReference<InnerExistDTO> InnerExistDTOType = new ParameterizedTypeReference<InnerExistDTO>() {
    };
    private static final ParameterizedTypeReference<IamResultDTO<Object>> ObjectType = new ParameterizedTypeReference<IamResultDTO<Object>>() {
    };
    private static final ParameterizedTypeReference<UserRoleDTO> UserRoleDTOType = new ParameterizedTypeReference<UserRoleDTO>() {
    };
    private static final ParameterizedTypeReference<WithTenantRespDTO> WithTenantRespDTOType = new ParameterizedTypeReference<WithTenantRespDTO>() {
    };
    private static final ParameterizedTypeReference<IamResultDTO<PersonalizedDTO>> PersonalizedDTOType = new ParameterizedTypeReference<IamResultDTO<PersonalizedDTO>>() {
    };

    private static final String VIRTUAL_TOKEN_URL = getIamUri() + "/api/iam/v2/identity/login/internal";

    public static JSONObject queryApiVirtualToken(String tenantId) {
        VirtualTokenReqDTO virtualTokenDTO = new VirtualTokenReqDTO();
        virtualTokenDTO.setTenantId(tenantId);
        return DwSpringHttpUtil.post(VIRTUAL_TOKEN_URL, virtualTokenDTO, JSONObjectType, httpHeaders -> httpHeaders.add(DwHttpHeaderConstants.Header_App_Token, DwHttpHeaderConstants.App_Token_Athena));
    }

    /**
     * 获取第三方平台的映射用户信息
     */
    public static final String GMC_V_2_MAPPING_QUERY_URL = getIamUri() + "/api/iam/v2/mapping/query";

    public static List<JSONObject> queryAppUser(long sid, String token, String identityId) {
        Map<String, Object> param = new HashMap<>();
        param.put("userSid", sid);
        param.put("identityId", identityId);
        return DwSpringHttpUtil.post(GMC_V_2_MAPPING_QUERY_URL, param, JSONObjectListType, httpHeaders -> {
            httpHeaders.set(DwHttpHeaderConstants.Header_User_Token, token);
            httpHeaders.set(DwHttpHeaderConstants.Header_App_Token, DwHttpHeaderConstants.App_Token_Athena);
        });
    }

    /**
     * 测试租户
     */
    public static final String TENANT_SIMPLE_URL = getIamUri() + "/api/iam/v2/tenant/simple";

    public static UserRoleDTO queryTenantSimple(String token, String id) {
        Map<String, String> param = new HashMap<>();
        param.put("id", id);
        return DwSpringHttpUtil.post(TENANT_SIMPLE_URL, param, UserRoleDTOType, httpHeaders -> httpHeaders.set(DwHttpHeaderConstants.Header_User_Token, token));

    }

    /**
     * 根据邮箱获取任务的实际执行人
     */
    public static final String USER_EMAIL_URL = getIamUri() + "/api/iam/v2/user/email";

    /**
     * 根据用户email和租户Id获取用户相关的信息
     *
     * @param email 用户email
     * @return 用户基本信息
     */
    public static IamResultDTO<UserDTO> queryByEmail(String email, String tenantId) {
        Map<String, String> param = new HashMap<>(2);
        param.put("email", email);
        param.put("tenantId", tenantId);
        return DwSpringHttpUtil.post(USER_EMAIL_URL, param, IamUserDTOType);

    }

    /**
     * 根据邮箱获取个人租户
     * status的值
     * -1 调用接口失败
     * 0 没有个人租户
     * 1 没有授权
     * 2 有个人租户并且有授权
     */
    public static final String USER_EMAIL_TENANTS_AUTH_URL = getIamUri() + "/api/iam/v2/user/email/tenants/auth";

    /**
     * 根据邮箱获取个人租户
     * status的值
     * -1 调用接口失败
     * 0 没有个人租户
     * 1 没有授权
     * 2 有个人租户并且有授权
     */
    public static IamResultDTO<BossIamTenantAuthDTO> getTenantAuth(AuthoredUser authoredUser, UserEmailTenantsAuthReqDTO userEmailTenantsAuthReqDTO) {
        return DwSpringHttpUtil.post(USER_EMAIL_TENANTS_AUTH_URL, userEmailTenantsAuthReqDTO, BossIamTenantAuthDTOType, httpHeaders -> httpHeaders.set(DwHttpHeaderConstants.Header_User_Token, authoredUser.getToken()));

    }

    /**
     * 判断邮箱帐号是否已经注册,且是否为鼎捷用户，排除掉企业内部用户
     */
    public static final String USER_EMAIL_WITHOUT_INNER_EXIST_URL = getIamUri() + "/api/iam/v2/user/email/without/inner/exist";

    /**
     * 判断邮箱帐号是否已经注册,且是否为鼎捷用户，排除掉企业内部用户
     */
    public static InnerExistDTO emailInnerExist(String email) {
        Map<String, Object> params = new HashMap<>();
        params.put("email", email);
        return DwSpringHttpUtil.post(USER_EMAIL_WITHOUT_INNER_EXIST_URL, params, InnerExistDTOType);

    }

    /**
     * 根据用户id获取用户相关的信息
     */
    public static final String USER_URL = getIamUri() + "/api/iam/v2/user/full";


    public static UserDTO queryUser(String userId) {
        Map<String, String> param = new HashMap<>();
        param.put("id", userId);
        return DwSpringHttpUtil.post(USER_URL, param, UserDTOType);

    }

    /**
     * 通过用户ID 获取是否静默
     */
    public static final String USER_METADATA_VALUE_URL = getIamUri() + "/api/iam/v2/user/metadata/value";


    /**
     * 通过用户ID 获取是否静默
     */
    public static IamResultDTO<Object> getMessageDoNotDisturbUserId(String userId, String tenantId, String token) {
        Map<String, String> param = new HashMap<>();
        param.put("tenantId", tenantId);
        param.put("userId", userId);
        param.put("catalogId", "basic");
        param.put("key", "doNotDisturb");
        return DwSpringHttpUtil.post(USER_METADATA_VALUE_URL, param, ObjectType, httpHeaders -> httpHeaders.set(DwHttpHeaderConstants.Header_User_Token, token));

    }

    /**
     * 根据用户id获取角色信息
     */
    public static final String USER_ROLE_URL = getIamUri() + "/api/iam/v2/user/role";


    public static UserRoleDTO queryUserRoles(String userId, String token) {
        Map<String, String> param = new HashMap<>();
        param.put("id", userId);
        return DwSpringHttpUtil.post(USER_ROLE_URL, param, UserRoleDTOType, httpHeaders -> {
            httpHeaders.add(DwHttpHeaderConstants.Header_User_Token, token);
        }, Collections.emptyMap());

    }


    /**
     * 获取用户的租户信息;4.11增加返回agreeAgreement
     * iam接口安全调整方案，替换/api/iam/v2/user/contacts接口;
     */
    public static final String TENANT_INFO_URL = getIamUri() + "/api/iam/v2/user/withtenant";

    /**
     * 根据用户id查询出用户的email
     * update: iam接口安全调整给了替换方案，替换为接口/api/iam/v2/user/withtenant
     *
     * @param userId 用户id
     */
    public static WithTenantRespDTO queryUserEmail(String userId) {

        Map<String, Object> param = new HashMap<>();
        param.put("id", userId);

        return DwSpringHttpUtil.post(TENANT_INFO_URL, param, WithTenantRespDTOType);
    }

    /**
     * 根据userSid获取租户语言别设置
     */
    public static final String USERMETADATA_USER_GET_URL = getIamUri() + "/api/iam/v2/usermetadata/user/get";

    /**
     * 查询用户的个性化设置数据
     * <p>
     * tenantSid 租户SID，注意非租户id
     * userId    用户id
     * key       需要查询的key
     * catalogId 类目id
     */
    public static IamResultDTO<PersonalizedDTO> queryPersonalizedInfo(QueryPersonalizedInfoReqDTO queryPersonalizedInfoReqDTO) {

        return DwSpringHttpUtil.post(USERMETADATA_USER_GET_URL, queryPersonalizedInfoReqDTO, PersonalizedDTOType);

    }

}
