package com.digiwin.athena.iam.sdk.meta.dto;

import com.digiwin.athena.iam.sdk.meta.dto.response.AuthoredUserDTO;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.meta.handler.JaResultParseHandler;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.SuperBuilder;
import org.springframework.util.StringUtils;

/**
 * iam 返回的数据格式
 *
 * @author gengwei
 * @since 2024/8/15 09:28
 */
@Setter
@Getter
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class IamResultBDTO<T> implements JaResultParseHandler<T> {

    private String timestamp;
    private String code;
    private String message;
    private String path;
    private Boolean success;
    private String sourceId;
    private String errorType;
    private String errorCode;
    private String errorMessage;
    private String expId;
    private T data;

    private long sid;
    @JsonProperty("id")
    private String userId;
    @JsonProperty("name")
    private String userName;
    private long tenantSid;
    private String tenantId;
    private String tenantName;
    private String token;
    private String identityType;

    @Override
    public Boolean success() {
        return !Boolean.FALSE.equals(success);
    }

    @Override
    public String code() {
        if (JaStringUtil.isNotEmpty(errorCode)) {
            return errorCode;
        }
        return String.valueOf(code);
    }

    @Override
    public String message() {
        if (JaStringUtil.isNotEmpty(errorMessage)) {
            return errorMessage;
        }
        return getMessage();
    }

    @Override
    public T data() {
        return (T) build();
    }

    private AuthoredUserDTO build() {
        if (StringUtils.isEmpty(this.userId)) {
            return null;
        }
        AuthoredUserDTO authoredUserDTO = new AuthoredUserDTO();
        authoredUserDTO.setSid(this.sid);
        authoredUserDTO.setUserId(this.userId);
        authoredUserDTO.setUserName(this.userName);
        authoredUserDTO.setTenantSid(this.tenantSid);
        authoredUserDTO.setTenantId(this.tenantId);
        authoredUserDTO.setTenantName(this.tenantName);
        authoredUserDTO.setToken(this.token);
        authoredUserDTO.setIdentityType(this.identityType);
        return authoredUserDTO;
    }
}
