/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.iam.sdk.manager;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.common.sdk.manager.util.DwHttpResultParseUtil;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import com.digiwin.athena.iam.sdk.meta.dto.IamResultBDTO;
import com.digiwin.athena.iam.sdk.meta.dto.request.UserDataPermissionParamDTO;
import com.digiwin.athena.iam.sdk.meta.dto.request.UserDataPermissionResultDTO;
import com.digiwin.athena.iam.sdk.meta.dto.response.AuthoredUserDTO;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.meta.handler.JaResultParseHandler;
import org.springframework.core.ParameterizedTypeReference;

public class IamAuthManager {
    private static final ParameterizedTypeReference<IamResultBDTO<AuthoredUserDTO>> AUTHORED_USER_DTO_PARAMETERIZED_TYPE_REFERENCE = new ParameterizedTypeReference<IamResultBDTO<AuthoredUserDTO>>(){};
    public static final String IDENTITY_TOKEN_ANALYZE = IamAuthManager.getIamUri() + "/api/iam/v2/identity/token/analyze";
    public static final String USER_DATA_PERMISSION = IamAuthManager.getIamUri() + "/api/iam/v2/permission/data";

    private static String getIamUri() {
        return JaProperty.get((String)"iam.uri");
    }

    public static AuthoredUserDTO getUserInfo(String token) {
        if (JaStringUtil.isEmpty((String)token)) {
            throw BusinessException.buildBizErrorCode((String)"P.IAM.500.5001");
        }
        AuthoredUserDTO result = null;
        try {
            result = (AuthoredUserDTO)DwHttpResultParseUtil.parse((JaResultParseHandler)((JaResultParseHandler)DwSpringHttpUtil.post((String)IDENTITY_TOKEN_ANALYZE, null, AUTHORED_USER_DTO_PARAMETERIZED_TYPE_REFERENCE, httpHeaders -> httpHeaders.set("digi-middleware-auth-user", token))));
        }
        catch (BusinessException e) {
            e.setBizErrorCode(e.getErrorCode());
            e.setBizErrorMsg(null == e.getErrorMessage() ? "" : e.getErrorMessage().toString());
            throw e;
        }
        catch (Throwable e) {
            throw BusinessException.buildErrorCode((String)"P.IAM.500.5002");
        }
        if (null == result) {
            throw BusinessException.buildErrorCode((String)"P.IAM.500.5002");
        }
        return result;
    }

    public static UserDataPermissionResultDTO queryUserDataPermission(String moduleId, String actionId, String sysId, String token) {
        UserDataPermissionParamDTO paramDTO = new UserDataPermissionParamDTO();
        paramDTO.setModuleId(moduleId);
        paramDTO.setActionId(actionId);
        paramDTO.setSysId(sysId);
        UserDataPermissionResultDTO resultDTO = (UserDataPermissionResultDTO)DwSpringHttpUtil.post((String)IDENTITY_TOKEN_ANALYZE, (Object)paramDTO, (ParameterizedTypeReference)new ParameterizedTypeReference<UserDataPermissionResultDTO>(){}, httpHeaders -> httpHeaders.set("digi-middleware-auth-user", token));
        return resultDTO;
    }
}

