/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.iam.sdk.manager;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import com.digiwin.athena.iam.sdk.meta.dto.IamResultDTO;
import com.digiwin.athena.iam.sdk.meta.dto.request.QueryAppUserDTO;
import com.digiwin.athena.iam.sdk.meta.dto.request.QueryByEmailDTO;
import com.digiwin.athena.iam.sdk.meta.dto.request.QueryByIdDTO;
import com.digiwin.athena.iam.sdk.meta.dto.request.QueryDisturbUserDTO;
import com.digiwin.athena.iam.sdk.meta.dto.request.QueryPersonalizedInfoReqDTO;
import com.digiwin.athena.iam.sdk.meta.dto.request.UserEmailTenantsAuthReqDTO;
import com.digiwin.athena.iam.sdk.meta.dto.request.VirtualTokenReqDTO;
import com.digiwin.athena.iam.sdk.meta.dto.response.BossIamTenantAuthDTO;
import com.digiwin.athena.iam.sdk.meta.dto.response.InnerExistDTO;
import com.digiwin.athena.iam.sdk.meta.dto.response.PersonalizedDTO;
import com.digiwin.athena.iam.sdk.meta.dto.response.UserDTO;
import com.digiwin.athena.iam.sdk.meta.dto.response.UserRoleDTO;
import com.digiwin.athena.iam.sdk.meta.dto.response.WithTenantRespDTO;
import com.jugg.agile.framework.core.config.JaProperty;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;

public class IamManager {
    private static final String CATALOG_ID = "basic";
    private static final String KEY = "doNotDisturb";
    private static final ParameterizedTypeReference<JSONObject> JSONObjectType = new ParameterizedTypeReference<JSONObject>(){};
    private static final ParameterizedTypeReference<List<JSONObject>> JSONObjectListType = new ParameterizedTypeReference<List<JSONObject>>(){};
    private static final ParameterizedTypeReference<IamResultDTO<Map<Object, Object>>> MapType = new ParameterizedTypeReference<IamResultDTO<Map<Object, Object>>>(){};
    private static final ParameterizedTypeReference<UserDTO> UserDTOType = new ParameterizedTypeReference<UserDTO>(){};
    private static final ParameterizedTypeReference<IamResultDTO<UserDTO>> IamUserDTOType = new ParameterizedTypeReference<IamResultDTO<UserDTO>>(){};
    private static final ParameterizedTypeReference<IamResultDTO<BossIamTenantAuthDTO>> BossIamTenantAuthDTOType = new ParameterizedTypeReference<IamResultDTO<BossIamTenantAuthDTO>>(){};
    private static final ParameterizedTypeReference<InnerExistDTO> InnerExistDTOType = new ParameterizedTypeReference<InnerExistDTO>(){};
    private static final ParameterizedTypeReference<IamResultDTO<Object>> ObjectType = new ParameterizedTypeReference<IamResultDTO<Object>>(){};
    private static final ParameterizedTypeReference<UserRoleDTO> UserRoleDTOType = new ParameterizedTypeReference<UserRoleDTO>(){};
    private static final ParameterizedTypeReference<WithTenantRespDTO> WithTenantRespDTOType = new ParameterizedTypeReference<WithTenantRespDTO>(){};
    private static final ParameterizedTypeReference<IamResultDTO<PersonalizedDTO>> PersonalizedDTOType = new ParameterizedTypeReference<IamResultDTO<PersonalizedDTO>>(){};
    private static final String VIRTUAL_TOKEN_URL = IamManager.getIamUri() + "/api/iam/v2/identity/login/internal";
    public static final String GMC_V_2_MAPPING_QUERY_URL = IamManager.getIamUri() + "/api/iam/v2/mapping/query";
    public static final String TENANT_SIMPLE_URL = IamManager.getIamUri() + "/api/iam/v2/tenant/simple";
    public static final String USER_EMAIL_URL = IamManager.getIamUri() + "/api/iam/v2/user/email";
    public static final String USER_EMAIL_TENANTS_AUTH_URL = IamManager.getIamUri() + "/api/iam/v2/user/email/tenants/auth";
    public static final String USER_EMAIL_WITHOUT_INNER_EXIST_URL = IamManager.getIamUri() + "/api/iam/v2/user/email/without/inner/exist";
    public static final String USER_URL = IamManager.getIamUri() + "/api/iam/v2/user/full";
    public static final String USER_METADATA_VALUE_URL = IamManager.getIamUri() + "/api/iam/v2/user/metadata/value";
    public static final String USER_ROLE_URL = IamManager.getIamUri() + "/api/iam/v2/user/role";
    public static final String TENANT_INFO_URL = IamManager.getIamUri() + "/api/iam/v2/user/withtenant";
    public static final String USERMETADATA_USER_GET_URL = IamManager.getIamUri() + "/api/iam/v2/usermetadata/user/get";

    private static String getIamUri() {
        return JaProperty.get((String)"iam.uri");
    }

    public static JSONObject queryApiVirtualToken(String tenantId) {
        VirtualTokenReqDTO virtualTokenDTO = new VirtualTokenReqDTO();
        virtualTokenDTO.setTenantId(tenantId);
        return (JSONObject)DwSpringHttpUtil.post((String)VIRTUAL_TOKEN_URL, (Object)virtualTokenDTO, JSONObjectType, httpHeaders -> httpHeaders.add("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c"));
    }

    public static List<JSONObject> queryAppUser(long sid, String token, String identityId) {
        Object body = ((QueryAppUserDTO.QueryAppUserDTOBuilder)((QueryAppUserDTO.QueryAppUserDTOBuilder)QueryAppUserDTO.builder().userSid(sid)).identityId(identityId)).build();
        return (List)DwSpringHttpUtil.post((String)GMC_V_2_MAPPING_QUERY_URL, body, JSONObjectListType, httpHeaders -> {
            httpHeaders.set("digi-middleware-auth-user", token);
            httpHeaders.set("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        });
    }

    public static UserRoleDTO queryTenantSimple(String token, String id) {
        Object body = ((QueryByIdDTO.QueryByIdDTOBuilder)QueryByIdDTO.builder().id(id)).build();
        return (UserRoleDTO)DwSpringHttpUtil.post((String)TENANT_SIMPLE_URL, body, UserRoleDTOType, httpHeaders -> httpHeaders.set("digi-middleware-auth-user", token));
    }

    public static IamResultDTO<UserDTO> queryByEmail(String email, String tenantId) {
        Object body = ((QueryByEmailDTO.QueryByEmailDTOBuilder)((QueryByEmailDTO.QueryByEmailDTOBuilder)QueryByEmailDTO.builder().email(email)).tenantId(tenantId)).build();
        return (IamResultDTO)DwSpringHttpUtil.post((String)USER_EMAIL_URL, body, IamUserDTOType);
    }

    public static IamResultDTO<BossIamTenantAuthDTO> getTenantAuth(AuthoredUser authoredUser, UserEmailTenantsAuthReqDTO userEmailTenantsAuthReqDTO) {
        return (IamResultDTO)DwSpringHttpUtil.post((String)USER_EMAIL_TENANTS_AUTH_URL, (Object)userEmailTenantsAuthReqDTO, BossIamTenantAuthDTOType, httpHeaders -> httpHeaders.set("digi-middleware-auth-user", authoredUser.getToken()));
    }

    public static InnerExistDTO emailInnerExist(String email) {
        Object body = ((QueryByEmailDTO.QueryByEmailDTOBuilder)QueryByEmailDTO.builder().email(email)).build();
        return (InnerExistDTO)DwSpringHttpUtil.post((String)USER_EMAIL_WITHOUT_INNER_EXIST_URL, body, InnerExistDTOType);
    }

    public static UserDTO queryUser(String userId) {
        Object body = ((QueryByIdDTO.QueryByIdDTOBuilder)QueryByIdDTO.builder().id(userId)).build();
        return (UserDTO)DwSpringHttpUtil.post((String)USER_URL, body, UserDTOType);
    }

    public static IamResultDTO<Object> getMessageDoNotDisturbUserId(String userId, String tenantId, String token) {
        Object body = ((QueryDisturbUserDTO.QueryDisturbUserDTOBuilder)((QueryDisturbUserDTO.QueryDisturbUserDTOBuilder)((QueryDisturbUserDTO.QueryDisturbUserDTOBuilder)((QueryDisturbUserDTO.QueryDisturbUserDTOBuilder)QueryDisturbUserDTO.builder().tenantId(tenantId)).userId(userId)).catalogId(CATALOG_ID)).key(KEY)).build();
        return (IamResultDTO)DwSpringHttpUtil.post((String)USER_METADATA_VALUE_URL, body, ObjectType, httpHeaders -> httpHeaders.set("digi-middleware-auth-user", token));
    }

    public static UserRoleDTO queryUserRoles(String userId, String token) {
        Object body = ((QueryByIdDTO.QueryByIdDTOBuilder)QueryByIdDTO.builder().id(userId)).build();
        return (UserRoleDTO)DwSpringHttpUtil.post((String)USER_ROLE_URL, body, UserRoleDTOType, httpHeaders -> httpHeaders.add("digi-middleware-auth-user", token), Collections.emptyMap());
    }

    public static WithTenantRespDTO queryUserEmail(String userId) {
        Object body = ((QueryByIdDTO.QueryByIdDTOBuilder)QueryByIdDTO.builder().id(userId)).build();
        return (WithTenantRespDTO)DwSpringHttpUtil.post((String)TENANT_INFO_URL, body, WithTenantRespDTOType);
    }

    public static IamResultDTO<PersonalizedDTO> queryPersonalizedInfo(QueryPersonalizedInfoReqDTO queryPersonalizedInfoReqDTO) {
        return (IamResultDTO)DwSpringHttpUtil.post((String)USERMETADATA_USER_GET_URL, (Object)queryPersonalizedInfoReqDTO, PersonalizedDTOType);
    }
}

