package com.digiwin.athena.iam.sdk.meta.dto.response;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.util.Map;

/**
 * 用户应用权限
 * @author yinhaiye
 * @since 2025/08/13 10:00
 */
@Setter
@Getter
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class UserPermissionDTO implements Serializable {
    // sid
    private String sid;
    // id
    private String id;
    // 权限名称
    private String name;
    // 权限模板id
    private String moduleId;
    // 权限code
    private String target;
    // 是否授权 allow为授权
    private String effect;
    // 按钮权限数据
    private Map<String,  Object> conditions;
}
