/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.iam.sdk.manager;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.common.sdk.manager.util.DwHttpResultParseUtil;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import com.digiwin.athena.iam.sdk.meta.dto.IamResultBDTO;
import com.digiwin.athena.iam.sdk.meta.dto.IamResultDTO;
import com.digiwin.athena.iam.sdk.meta.dto.request.UserDataPermissionParamDTO;
import com.digiwin.athena.iam.sdk.meta.dto.request.UserDataPermissionResultDTO;
import com.digiwin.athena.iam.sdk.meta.dto.response.AuthoredUserDTO;
import com.digiwin.athena.iam.sdk.meta.dto.response.UserPermissionDTO;
import com.digiwin.athena.iam.sdk.meta.dto.response.UserPermissionListDTO;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.meta.handler.JaResultParseHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.util.CollectionUtils;

public class IamAuthManager {
    private static final ParameterizedTypeReference<IamResultBDTO<AuthoredUserDTO>> AUTHORED_USER_DTO_PARAMETERIZED_TYPE_REFERENCE = new ParameterizedTypeReference<IamResultBDTO<AuthoredUserDTO>>(){};
    private static final ParameterizedTypeReference<IamResultDTO<List<UserPermissionDTO>>> USER_PERMISSION_DTO_PARAMETERIZED_TYPE_REFERENCE = new ParameterizedTypeReference<IamResultDTO<List<UserPermissionDTO>>>(){};
    private static final ParameterizedTypeReference<List<UserPermissionListDTO>> USER_PERMISSION_LIST_DTO_PARAMETERIZED_TYPE_REFERENCE = new ParameterizedTypeReference<List<UserPermissionListDTO>>(){};
    private static final String USER_PERMISSION2 = IamAuthManager.getIamUri() + "/api/iam/v2/permission/user";
    private static final String USER_PERMISSION2_ALL = IamAuthManager.getIamUri() + "/api/iam/v2/permission/users/apps/all";
    public static final String IDENTITY_TOKEN_ANALYZE = IamAuthManager.getIamUri() + "/api/iam/v2/identity/token/analyze";
    public static final String USER_DATA_PERMISSION = IamAuthManager.getIamUri() + "/api/iam/v2/permission/data";

    private static String getIamUri() {
        return JaProperty.get((String)"iam.uri");
    }

    public static AuthoredUserDTO getUserInfo(String token) {
        if (JaStringUtil.isEmpty((String)token)) {
            throw BusinessException.buildBizErrorCode((String)"P.IAM.500.5001");
        }
        AuthoredUserDTO result = null;
        try {
            result = (AuthoredUserDTO)DwHttpResultParseUtil.parse((JaResultParseHandler)((JaResultParseHandler)DwSpringHttpUtil.post((String)IDENTITY_TOKEN_ANALYZE, null, AUTHORED_USER_DTO_PARAMETERIZED_TYPE_REFERENCE, httpHeaders -> httpHeaders.set("digi-middleware-auth-user", token))));
        }
        catch (BusinessException e) {
            e.setBizErrorCode(e.getErrorCode());
            e.setBizErrorMsg(null == e.getErrorMessage() ? "" : e.getErrorMessage().toString());
            throw e;
        }
        catch (Throwable e) {
            throw BusinessException.buildErrorCode((String)"P.IAM.500.5002");
        }
        if (null == result) {
            throw BusinessException.buildErrorCode((String)"P.IAM.500.5002");
        }
        return result;
    }

    public static UserDataPermissionResultDTO.RowPermission queryUserDataPermission(String moduleId, String actionId, String sysId, String token) {
        UserDataPermissionParamDTO paramDTO = new UserDataPermissionParamDTO();
        paramDTO.setModuleId(moduleId);
        paramDTO.setActionId(actionId);
        paramDTO.setSysId(sysId);
        Map resultMap = (Map)DwSpringHttpUtil.post((String)USER_DATA_PERMISSION, (Object)paramDTO, (ParameterizedTypeReference)new ParameterizedTypeReference<Map>(){}, httpHeaders -> httpHeaders.set("digi-middleware-auth-user", token));
        if (Objects.isNull(resultMap) || !resultMap.containsKey("rowPermission") || Objects.isNull(resultMap.containsKey("rowPermission")) || resultMap.get("rowPermission") instanceof Collection) {
            return null;
        }
        UserDataPermissionResultDTO resultDTO = (UserDataPermissionResultDTO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)resultMap), UserDataPermissionResultDTO.class);
        if (Objects.isNull(resultDTO) || Objects.isNull(resultDTO.getRowPermission()) || CollectionUtils.isEmpty(resultDTO.getRowPermission().getFilterValue())) {
            return null;
        }
        return resultDTO.getRowPermission();
    }

    public static List<UserPermissionDTO> getUserPermission(String appCode) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("userId", authoredUser.getUserId());
        requestMap.put("sysId", appCode);
        return (List)DwHttpResultParseUtil.parse((JaResultParseHandler)((JaResultParseHandler)DwSpringHttpUtil.post((String)USER_PERMISSION2, requestMap, USER_PERMISSION_DTO_PARAMETERIZED_TYPE_REFERENCE, httpHeaders -> {
            httpHeaders.set("Content-Type", "application/json");
            httpHeaders.set("digi-middleware-auth-user", authoredUser.getToken());
        })));
    }

    public static List<UserPermissionListDTO> getUserPermissionByCodes(List<String> appCodes, String effect) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("userIds", Collections.singletonList(authoredUser.getUserId()));
        requestMap.put("sysIds", appCodes);
        if (JaStringUtil.isNotEmpty((String)effect)) {
            requestMap.put("effect", effect);
        }
        return (List)DwSpringHttpUtil.post((String)USER_PERMISSION2_ALL, requestMap, USER_PERMISSION_LIST_DTO_PARAMETERIZED_TYPE_REFERENCE, httpHeaders -> {
            httpHeaders.set("Content-Type", "application/json");
            httpHeaders.set("digi-middleware-auth-user", authoredUser.getToken());
        });
    }
}

