package com.digiwin.athena.im.sdk.manager;

import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import com.digiwin.athena.im.sdk.meta.dto.ImResultDTO;
import com.digiwin.athena.im.sdk.meta.dto.response.ImNeteaseUserDTO;
import com.jugg.agile.framework.core.config.JaProperty;
import org.springframework.core.ParameterizedTypeReference;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * atdm 相关接口
 *
 * @author gengwei
 * @since 2024/9/2 17:45
 */
public class ImManager {

    private static String getImUri() {
        return JaProperty.get("im.uri");
    }

    private static final ParameterizedTypeReference<ImResultDTO<List<ImNeteaseUserDTO>>> ImNeteaseUserDTOListType = new ParameterizedTypeReference<ImResultDTO<List<ImNeteaseUserDTO>>>() {
    };

    /**
     * 批量根据userId获取IM 网易云信账号
     */
    public static final String USER_GET_USER_INFO_BY_USER_IDS_URL = getImUri() + "/user/getUserInfoByUserIds";

    /**
     * 批量根据userId获取IM 网易云信账号
     */
    public static ImResultDTO<List<ImNeteaseUserDTO>> queryNeteaseUsers(List<String> userIdList) {
        Map<String, Object> condition = new HashMap<>();
        condition.put("userIds", userIdList);
        return DwSpringHttpUtil.post(USER_GET_USER_INFO_BY_USER_IDS_URL, condition, ImNeteaseUserDTOListType);

    }

}
