/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.sdk.manager;

import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import com.digiwin.athena.knowledgegraph.sdk.meta.dto.KgResultDTO;
import com.digiwin.athena.knowledgegraph.sdk.meta.dto.request.ActivityDefinitionListReqDTO;
import com.digiwin.athena.knowledgegraph.sdk.meta.dto.request.TaskCardFieldReqDTO;
import com.digiwin.athena.knowledgegraph.sdk.meta.dto.response.kg.TaskCardFieldRespDTO;
import com.digiwin.athena.knowledgegraph.sdk.meta.dto.response.thememap.BaseItemRespDTO;
import com.digiwin.athena.knowledgegraph.sdk.meta.dto.response.thememap.BusinessKeyDTO;
import com.digiwin.athena.knowledgegraph.sdk.meta.dto.response.thememap.TmActivityResponseDTO;
import com.digiwin.athena.knowledgegraph.sdk.meta.dto.response.thememap.TmAppRespDTO;
import com.digiwin.athena.knowledgegraph.sdk.meta.dto.response.thememap.TmReportRespDTO;
import com.digiwin.athena.knowledgegraph.sdk.meta.dto.response.thememap.TmTaskDefineResponseDTO;
import com.digiwin.athena.knowledgegraph.sdk.meta.dto.response.thememap.WorkbenchSettingRespDTO;
import com.jugg.agile.framework.core.config.JaProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.util.UriComponentsBuilder;

public class KnowledgegraphManager {
    private static final ParameterizedTypeReference<KgResultDTO<List<TmAppRespDTO>>> TmAppDTOListType = new ParameterizedTypeReference<KgResultDTO<List<TmAppRespDTO>>>(){};
    private static final ParameterizedTypeReference<KgResultDTO<List<String>>> StringListType = new ParameterizedTypeReference<KgResultDTO<List<String>>>(){};
    private static final ParameterizedTypeReference<KgResultDTO<List<TmActivityResponseDTO>>> TmActivityResponseDTOListType = new ParameterizedTypeReference<KgResultDTO<List<TmActivityResponseDTO>>>(){};
    private static final ParameterizedTypeReference<KgResultDTO<TmActivityResponseDTO>> TmActivityResponseDTOType = new ParameterizedTypeReference<KgResultDTO<TmActivityResponseDTO>>(){};
    private static final ParameterizedTypeReference<KgResultDTO<List<TmTaskDefineResponseDTO>>> TmTaskDefineResponseDTOListType = new ParameterizedTypeReference<KgResultDTO<List<TmTaskDefineResponseDTO>>>(){};
    private static final ParameterizedTypeReference<KgResultDTO<Map<String, Map<Object, Object>>>> MapMapType = new ParameterizedTypeReference<KgResultDTO<Map<String, Map<Object, Object>>>>(){};
    private static final ParameterizedTypeReference<KgResultDTO<List<TmReportRespDTO>>> TmReportRespDTOListType = new ParameterizedTypeReference<KgResultDTO<List<TmReportRespDTO>>>(){};
    private static final ParameterizedTypeReference<KgResultDTO<Map<String, Object>>> MapType = new ParameterizedTypeReference<KgResultDTO<Map<String, Object>>>(){};
    private static final ParameterizedTypeReference<KgResultDTO<TmTaskDefineResponseDTO>> TmTaskDefineResponseDTOType = new ParameterizedTypeReference<KgResultDTO<TmTaskDefineResponseDTO>>(){};
    private static final ParameterizedTypeReference<KgResultDTO<Boolean>> BooleanType = new ParameterizedTypeReference<KgResultDTO<Boolean>>(){};
    private static final ParameterizedTypeReference<KgResultDTO<List<TaskCardFieldRespDTO>>> TaskCardFieldRespDTOListType = new ParameterizedTypeReference<KgResultDTO<List<TaskCardFieldRespDTO>>>(){};
    private static final ParameterizedTypeReference<KgResultDTO<BusinessKeyDTO>> BusinessKeyDTOType = new ParameterizedTypeReference<KgResultDTO<BusinessKeyDTO>>(){};
    private static final ParameterizedTypeReference<KgResultDTO<WorkbenchSettingRespDTO>> WorkbenchSettingRespDTOType = new ParameterizedTypeReference<KgResultDTO<WorkbenchSettingRespDTO>>(){};
    private static final ParameterizedTypeReference<KgResultDTO<List<BaseItemRespDTO>>> BaseItemRespDTOListType = new ParameterizedTypeReference<KgResultDTO<List<BaseItemRespDTO>>>(){};
    public static final String TASK_APPLICATION_RELATION_URL = KnowledgegraphManager.getKnowledgeGraphUri() + "knowledgegraph/task/applicationRelation";
    public static final String APP_CODE_BY_TASK_CODE_URL = KnowledgegraphManager.getKnowledgeGraphUri() + "knowledgegraph/app/appCodeByTaskCode?code={code}";
    public static final String RESTFUL_SERVICE_KNOWLEDGEGRAPH_APP_TASK_CODE_APP_CODE_URL = KnowledgegraphManager.getKnowledgeGraphUri() + "knowledgegraph/app/taskCode?appCode={appCode}";
    public static final String BATCH_ACTIVITY_BASIC_URL = KnowledgegraphManager.getKnowledgeGraphUri() + "knowledgegraph/batch/activityBasic";
    public static final String BATCH_TASK_BASIC_URL = KnowledgegraphManager.getKnowledgeGraphUri() + "knowledgegraph/batch/taskBasic";
    public static final String TASK_ACTIVITY_DEFINITION_TASK_ID_ACTIVITY_ID_PAGE_CODE_URL = KnowledgegraphManager.getKnowledgeGraphUri() + "knowledgegraph/task/activityDefinition?taskId={taskId}&activityId={activityId}&pageCode={pageCode}";
    public static final String TASK_ACTIVITY_DEFINITION_ACTIVITY_ID_PAGE_CODE_URL = KnowledgegraphManager.getKnowledgeGraphUri() + "knowledgegraph/task/activityDefinition?activityId={activityId}&pageCode={pageCode}";
    public static final String TASK_ACTIVITY_DEFINITION_LIST_URL = KnowledgegraphManager.getKnowledgeGraphUri() + "knowledgegraph/task/activityDefinitionList";
    public static final String TASK_ACTIVITY_START_TARGET_CODE_TASK_ID_ACTIVITY_ID_PAGE_CODE_URL = KnowledgegraphManager.getKnowledgeGraphUri() + "knowledgegraph/task/activityStartTargetCode?taskId={taskId}&activityId={activityId}&pageCode={pageCode}";
    public static final String TASK_BIZS_BY_REPORT_CODE_NTYPE_URL = KnowledgegraphManager.getKnowledgeGraphUri() + "knowledgegraph/task/bizsByReportCodeNType";
    public static final String TASK_CARD_OPTIMIZE_RULES_URL = KnowledgegraphManager.getKnowledgeGraphUri() + "knowledgegraph/task/cardConfig";
    public static final String CARD_CONFIG_URL = KnowledgegraphManager.getKnowledgeGraphUri() + "knowledgegraph/task/cardConfigByType";
    public static final String TASK_DEFINITION_WITH_MULTI_LANGUAGE_TASK_ID_URL = KnowledgegraphManager.getKnowledgeGraphUri() + "knowledgegraph/task/definitionWithMultiLanguage?taskId={taskId}";
    public static final String QUERY_CONDITION_URL = KnowledgegraphManager.getKnowledgeGraphUri() + "knowledgegraph/task/queryCondition";
    public static final String TASK_REPORTS_BY_BIZ_CODE_NTYPE_URL = KnowledgegraphManager.getKnowledgeGraphUri() + "knowledgegraph/task/reportsByBizCodeNType";
    public static final String TASK_ORDER_STATUS_URL = KnowledgegraphManager.getKnowledgeGraphUri() + "knowledgegraph/task/taskOrderStatus";
    public static final String VIEW_TASKCARDFIELD_URL = KnowledgegraphManager.getKnowledgeGraphUri() + "knowledgegraph/task/viewTaskCardField";
    public static final String VIEW_BK_URL = KnowledgegraphManager.getKnowledgeGraphUri() + "knowledgegraph/view/bk";
    public static final String VIEW_EMAIL_URL = KnowledgegraphManager.getKnowledgeGraphUri() + "knowledgegraph/view/email";
    public static final String WORKBENCH_SETTING_URL = KnowledgegraphManager.getKnowledgeGraphUri() + "knowledgegraph/workbenchSetting/workbenchSetting?pageCode={pageCode}&configType={configType}&appCondition={appCondition}";
    public static final String ACTIVITIES_BY_PATTERN = KnowledgegraphManager.getKnowledgeGraphUri() + "/knowledgegraph/task/activitiesByPattern?pattern=DATA_ENTRY";

    private static String getKnowledgeGraphUri() {
        return JaProperty.get((String)"themeMap.knowledgeGraphUri");
    }

    public static KgResultDTO<List<BaseItemRespDTO>> getActivitiesByPattern() {
        HashMap paramMap = new HashMap();
        return (KgResultDTO)((Object)DwSpringHttpUtil.get((String)ACTIVITIES_BY_PATTERN, BaseItemRespDTOListType, paramMap));
    }

    public static KgResultDTO<List<TmAppRespDTO>> getApplicationRelation(String type, List<String> codeList) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("type", type);
        params.put("codes", codeList);
        return (KgResultDTO)((Object)DwSpringHttpUtil.post((String)TASK_APPLICATION_RELATION_URL, params, TmAppDTOListType));
    }

    public static KgResultDTO<List<TmAppRespDTO>> getAppInfos(String code) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("code", code);
        return (KgResultDTO)((Object)DwSpringHttpUtil.get((String)APP_CODE_BY_TASK_CODE_URL, TmAppDTOListType, paramMap));
    }

    public static KgResultDTO<List<String>> getTaskCodeListByAppCode(String appCode) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("appCode", appCode);
        return (KgResultDTO)((Object)DwSpringHttpUtil.get((String)RESTFUL_SERVICE_KNOWLEDGEGRAPH_APP_TASK_CODE_APP_CODE_URL, StringListType, param));
    }

    public static KgResultDTO<List<TmActivityResponseDTO>> getBatchActivityAssigns(List<Map<Object, Object>> activities) {
        HashMap rootPara = new HashMap();
        HashMap<String, List<Map<Object, Object>>> qPara = new HashMap<String, List<Map<Object, Object>>>();
        qPara.put("taskAndActivities", activities);
        rootPara.put("q", qPara);
        return (KgResultDTO)((Object)DwSpringHttpUtil.post((String)BATCH_ACTIVITY_BASIC_URL, rootPara, TmActivityResponseDTOListType));
    }

    public static KgResultDTO<List<TmTaskDefineResponseDTO>> getBatchTaskAssigns(List<String> taskCodes) {
        HashMap rootPara = new HashMap();
        HashMap<String, List<String>> qPara = new HashMap<String, List<String>>();
        qPara.put("codes", taskCodes);
        rootPara.put("q", qPara);
        return (KgResultDTO)((Object)DwSpringHttpUtil.post((String)BATCH_TASK_BASIC_URL, rootPara, TmTaskDefineResponseDTOListType));
    }

    public static KgResultDTO<TmActivityResponseDTO> getActivityAction(String tmTaskId, String tmActivityId, String pageCode) {
        String url = TASK_ACTIVITY_DEFINITION_TASK_ID_ACTIVITY_ID_PAGE_CODE_URL;
        if ("__uibot__".equals(tmTaskId)) {
            url = TASK_ACTIVITY_DEFINITION_ACTIVITY_ID_PAGE_CODE_URL;
        }
        HashMap<String, String> param = new HashMap<String, String>(3);
        param.put("taskId", tmTaskId);
        param.put("activityId", tmActivityId);
        param.put("pageCode", pageCode);
        return (KgResultDTO)((Object)DwSpringHttpUtil.get((String)url, TmActivityResponseDTOType, param));
    }

    public static KgResultDTO<Map<String, Map<Object, Object>>> getActivityDefinitionListByPageCode(ActivityDefinitionListReqDTO activityDefinitionListReqDTO) {
        return (KgResultDTO)((Object)DwSpringHttpUtil.post((String)TASK_ACTIVITY_DEFINITION_LIST_URL, (Object)activityDefinitionListReqDTO, MapMapType));
    }

    public static KgResultDTO<TmActivityResponseDTO> getActivityTargetCode(String tmTaskId, String tmActivityId, String pageCode) {
        HashMap<String, String> param = new HashMap<String, String>(3);
        param.put("taskId", tmTaskId);
        param.put("activityId", tmActivityId);
        param.put("pageCode", pageCode);
        return (KgResultDTO)((Object)DwSpringHttpUtil.get((String)TASK_ACTIVITY_START_TARGET_CODE_TASK_ID_ACTIVITY_ID_PAGE_CODE_URL, TmActivityResponseDTOType, param));
    }

    public static KgResultDTO<List<TmReportRespDTO>> getReportRelativeActivities(String reportCode, Integer type) {
        String url = UriComponentsBuilder.fromHttpUrl((String)TASK_BIZS_BY_REPORT_CODE_NTYPE_URL).queryParam("reportCode", new Object[]{reportCode}).queryParam("type", new Object[]{type}).build().toUriString();
        return (KgResultDTO)((Object)DwSpringHttpUtil.get((String)url, TmReportRespDTOListType));
    }

    public static KgResultDTO<Map<String, Object>> getTaskCardOptimizeRules() {
        return (KgResultDTO)((Object)DwSpringHttpUtil.get((String)TASK_CARD_OPTIMIZE_RULES_URL, MapType));
    }

    public static KgResultDTO<Map<String, Object>> postCardConfigByType(String pageCode, Set<String> codes) {
        HashMap<String, Object> cardConfigQuery = new HashMap<String, Object>(2);
        cardConfigQuery.put("pageCode", pageCode);
        cardConfigQuery.put("codes", codes);
        HashMap<String, HashMap<String, Object>> body = new HashMap<String, HashMap<String, Object>>(1);
        body.put("cardConfigQuery", cardConfigQuery);
        return (KgResultDTO)((Object)DwSpringHttpUtil.post((String)CARD_CONFIG_URL, body, MapType));
    }

    public static KgResultDTO<TmTaskDefineResponseDTO> getTask(String taskId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("taskId", taskId);
        return (KgResultDTO)((Object)DwSpringHttpUtil.get((String)TASK_DEFINITION_WITH_MULTI_LANGUAGE_TASK_ID_URL, TmTaskDefineResponseDTOType, param));
    }

    public static KgResultDTO<Map<String, Object>> getQueryCondition(String pageCode, String conditionType) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("pageCode", pageCode);
        map.put("configType", conditionType);
        HashMap<String, HashMap<String, String>> body = new HashMap<String, HashMap<String, String>>(1);
        body.put("cardConditionQuery", map);
        return (KgResultDTO)((Object)DwSpringHttpUtil.post((String)QUERY_CONDITION_URL, body, MapType));
    }

    public static KgResultDTO<List<TmReportRespDTO>> getReportSummaryList(String bizCode, Integer type, String userId) {
        String url = UriComponentsBuilder.fromHttpUrl((String)TASK_REPORTS_BY_BIZ_CODE_NTYPE_URL).queryParam("bizCode", new Object[]{bizCode}).queryParam("type", new Object[]{type}).queryParam("userId", new Object[]{userId}).build().toUriString();
        return (KgResultDTO)((Object)DwSpringHttpUtil.get((String)url, TmReportRespDTOListType));
    }

    public static KgResultDTO<Boolean> getOrderDisplay() {
        return (KgResultDTO)((Object)DwSpringHttpUtil.get((String)TASK_ORDER_STATUS_URL, BooleanType));
    }

    public static KgResultDTO<List<TaskCardFieldRespDTO>> taskCardFieldRequest(TaskCardFieldReqDTO taskCardFieldRequest) {
        HashMap<String, TaskCardFieldReqDTO> body = new HashMap<String, TaskCardFieldReqDTO>();
        body.put("taskCardFieldRequest", taskCardFieldRequest);
        return (KgResultDTO)((Object)DwSpringHttpUtil.post((String)VIEW_TASKCARDFIELD_URL, body, TaskCardFieldRespDTOListType));
    }

    public static KgResultDTO<BusinessKeyDTO> getTaskActivityBK(String objectType, String objectValue) {
        HashMap<String, String> request = new HashMap<String, String>(2);
        request.put("objectType", objectType);
        request.put("objectValue", objectValue);
        HashMap<String, HashMap<String, String>> body = new HashMap<String, HashMap<String, String>>(1);
        body.put("request", request);
        return (KgResultDTO)((Object)DwSpringHttpUtil.post((String)VIEW_BK_URL, body, BusinessKeyDTOType));
    }

    public static KgResultDTO<Map<String, Object>> getEmailEventIdByLocale(String emailCode, String locale) {
        String url = UriComponentsBuilder.fromHttpUrl((String)VIEW_EMAIL_URL).queryParam("emailCode", new Object[]{emailCode}).queryParam("locale", new Object[]{locale}).build().toUriString();
        return (KgResultDTO)((Object)DwSpringHttpUtil.get((String)url, MapType));
    }

    public static KgResultDTO<WorkbenchSettingRespDTO> getWorkbenchSetting(String pageCode, String configType) {
        HashMap<String, Object> urlParam = new HashMap<String, Object>(3);
        urlParam.put("pageCode", pageCode);
        urlParam.put("configType", configType);
        urlParam.put("appCondition", false);
        return (KgResultDTO)((Object)DwSpringHttpUtil.get((String)WORKBENCH_SETTING_URL, WorkbenchSettingRespDTOType, urlParam));
    }
}

