package com.digiwin.athena.knowledgegraph.sdk.meta.dto.response.thememap;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.SuperBuilder;

import java.util.List;
import java.util.Map;

@Setter
@Getter
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TmActionDTO {

    private int sequence;

    private Object title;

    private String actionId;

    /**
     * 活动类型，ESP或WF
     */
    private String type;
    private String serviceName;
    private String url;
    private String productUid;
    private String productName;
    //
    private Boolean needProxyToken;

    private String flatData;

    private List<TmActionParameterDTO> actionParams;

    private TmActionParameterDTO actionResponse;
    /**
     * 扩展参数，在需要做额外处理时可以使用
     */
    private Map<String, Object> extendParas;
    /**
     * 是否通知BPM，只有submitAction才会用到此值
     */
    private boolean dispatchBPM;
    /**
     * 检查完成的action,只有submitAction才会用到此值
     */
    private TmActionDTO checkCompleteAction;

    /**
     * submitAction显示的标题
     * 例如：已提交，已审核等
     */
    private Object returnText;

    /**
     * 查询数据时候直接提交
     */
    private List<TmActionDTO> attachActions;

    /**
     * 执行按扭时前端 执行的脚本
     */
    private String actionScript;

    /**
     * 提交API 缺失显示字段
     */
    private List<Map<String, String>> addShowFileds;

    /**
     * 数据处理器定义
     */
    private List<TmDataProcessDTO> dataProcessors;
}
