package com.digiwin.athena.knowledgegraph.sdk.meta.dto.response.action;


import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.*;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * Action实体定义
 */
@Setter
@Getter
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class SubmitAction extends Action implements Serializable {

    private static final long serialVersionUID = -4565532951186628228L;
    /**
     * 前端定义的ID
     * confirm:提交 cancel 取消
     */
    private String id;

    /**
     * 前端定义的UI 类型使用到
     */
    private List<Object> backFills;

    private String url;

    /**
     * 默认ACTION
     */
    private boolean defaultAction;

    /**
     * 执行上下文
     */
    private SubmitExecuteContext executeContext;


    /**
     * 扩展参数，在需要做额外处理时可以使用
     */
    private Map<String, Object> extendParas;

    /**
     * 批量提交
     * "isBatch": true,
     * "schema": "purchase"
     */
    private Map<String, Object> batch;

    /**
     * 提交的数据源是什么
     * "isBatch": true,
     * "schema": "purchase"
     */
    private SubmitType submitType;

    /**
     * 目标状态
     */
    private String targetDataState;
    /**
     * 执行按扭时前端 执行的脚本
     */
    private String actionScript;

    private Object returnText;

    /**
     * 判断是否结束
     */
    private Map checkCompleteAction;

    /**
     * 在任务结束之后才执行
     */
    private Boolean executeAfterCheckCompleted;

    /**
     * 提交API 缺失显示字段
     */
    private List<Map<String, String>> addShowFileds;


    /**
     * 签核-可退回的任务ID列表
     */
    private List<String> startApproveActivity;

    /**
     * 要执行的附加Action，可以为null
     */
    private List<SubmitAction> attachActions;

    /**
     * 提交数据 特殊处理
     */
    private List<Map> submitProcessors;

    /**
     * 按钮显示顺序，数字越小越显示在页面右侧
     */
    private Integer order;


    /**
     * 提交的数据schema集合，不指定表示提交全部数据
     * <br>指定后，提交时只提交指定的数据
     */
    private List<String> submitSchemas;


    @JsonIgnore
    private SubmitAction mergeDataAction;

    /**
     * 是否需要压缩
     */
    @Builder.Default
    private Boolean needCompress = false;

    /**
     * 是否增量地提交，如果不是增量，name提交的是全部数据
     */
    @Builder.Default
    private Boolean enableCombinedPost = true;
    /**
     * action执行结果
     */
    private ExecuteResult executeResult;

    /**
     * action是否执行过
     */
    private Boolean executed;
    /**
     * action是否支持重试
     */
    private Boolean supportRetry;

    /**
     * 转派——调用应用接口转派失败是否阻断
     */
    private Boolean needBlock;

    private List<SubmitAction> actionList;

    @Override
    public String toString() {
        return String.format("%s ----- %s ----  %s", id, getActionId(), returnText);
    }
}
