package com.digiwin.athena.knowledgegraph.sdk.meta.dto.response.thememap;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.SuperBuilder;

/**
 * themeMap人员身份定义
 */
@Setter
@Getter
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TmUserIdentityDTO {

    /**
     * 人员类型：
     * user 用户
     * duty 职能
     * deptDirector 部门主管
     * deptUser 部门人员
     * personInchage 当责者
     */
    private String performerType;

    /**
     * 人员的值
     * user 用户：eoc中的userId
     * duty 职能：职能ID
     * deptDirector 部门主：部门ID
     * deptUser部门人员：部门ID
     * personInchage 当责者，无。
     */
    private String performerValue;


    private String relatedUserField;

    private TmActionDTO performerAction;

}
