package com.digiwin.athena.knowledgegraph.sdk.meta.dto.response.thememap;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;


@Setter
@Getter
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class BaseItemRespDTO implements Serializable {
    private String name;

    /**
     * 当ifCommon=true时，code会相同
     */
    private String code;
    /**
     * tbb的code对应是tbb的key，实际是一串uid
     * 但code应该是需要具有可读性的，不应该直接和某个key直接绑定
     * tbb的配置需要增加栏位（新增resCode），关联tbb报表的key，让code回归原有的含义
     */
    private String resCode;
    private String category;
    private String appCode;
    private String appName;
    private boolean commonUsed;
    private Long itemId;
    private String access;
    private String groupName;
    private String groupCode;
    private String groupSort;
    private String sort;
    private boolean ifCustom;

    /**
     * 是否为公共基础资料：true/false
     */
    private boolean ifCommon;

    /**
     * 是否为公共应用 addBy23472
     */
    private boolean commonApp;

    /**
     * 不展示报表
     */
    private Boolean subReport;
    /**
     * ABI报表类型（prpttpl-打印凭证；ebibase-明细）
     */
    private String categoryAbi;
}
