package com.digiwin.athena.ops.sdk.meta;

import com.digiwin.athena.common.sdk.manager.meta.dto.BaseResultDTO;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.meta.handler.JaResultParseHandler;
import lombok.*;
import lombok.experimental.SuperBuilder;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * TaskEngine 返回包装类
 *
 * @author gengwei
 * @since 2024/8/20 14:56
 */
@Setter
@Getter
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class OpsResultDTO<T> implements JaResultParseHandler<T> {

    private String code;
    private String msg;
    private T data;

    // getters and setters

    @Data
    public static class DataContainer {
        private int total;
        private List<Deployment> data;

        // getters and setters

        @Data
        public static class Deployment {
            private long id;
            private String cloud;
            private String area;
            private String appId;
            private String name;
            private String mode;
            private String state;
            private int readyToDelete;

            // getters and setters
        }
    }

    @Override
    public Boolean success() {
        return !StringUtils.isEmpty(code) && "10000".equals(code);
    }

    @Override
    public String code() {
        return this.code;
    }

    @Override
    public String message() {
        return this.msg;
    }

    @Override
    public T data() {
        return this.data;
    }
}
