package com.digiwin.athena.ptm.sdk.meta.dto.response;

import lombok.*;
import lombok.experimental.SuperBuilder;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * PTM签核历程
 */
@Setter
@Getter
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class PtmBacklogApprovalRespDTO {

    /**
     * 发起人信息
     */
    private String initiator;
    private LocalDateTime initiatorCreateTime;
    private LocalDateTime initiatorClosedTime;
    private String projectDefCode;
    private String taskDefCode;
    private List<SignProcess> signProcess;

    @Setter
    @Getter
    @SuperBuilder
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class SignProcess {
        /**
         * 是否发起人节点
         */
        private Boolean initiatorNode;
        /**
         * 发起人id，isInitiator=true是必传
         */
        private String initiatorId;
        private String bpmActivityOID;
        private String activityId;
        private String activityName;
        private String signType;
        private LocalDateTime startTime;
        private LocalDateTime completedTime;
        private Map<Object, Object> informer;
        private Integer state;
        private Integer subState;
        private List<WorkItem> workitemList;
        private String noticeInformer;
    }

    @Setter
    @Getter
    @SuperBuilder
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class WorkItem {
        private String workitemId;
        private String agentPerformerId;
        private Integer subState;
        private LocalDateTime createTime;
        private String performerName;
        private Integer createType;
        private String comment;
        private Integer state;
        private String performerId;
        private Integer performerType;
        private LocalDateTime closedTime;
        private List<ApprovelAttachmentRespDTO> attachments;
    }


}
