package com.digiwin.athena.ptm.sdk.meta.dto.request;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.SuperBuilder;

import java.util.List;

/**
 * TaskDataQueryModel
 * 查询任务data以及dataState请求类
 */
@Setter
@Getter
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TaskDataQueryModelReqDTO {
    /**
     * 待办id
     */
    private Long backlogId;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 任务id
     */
    private Long taskId;

    /**
     * 查询类型
     * data:只返回data dataState:只返回dataState
     */
    private String type;

    /**
     * 湖州专项-批量待办id列表
     */
    private List<Long> backlogIds;

    /**
     * 湖州专项 - 批量待办id列表 + 每个任务data数据需要的key
     */
    private List<TaskDataRequireKeyModel> taskDataRequireKeyModels;

    /**
     * 湖州专项-是否查询任务卡下全部活动数据信息
     */
    private boolean isAllQuery;
}
