package com.digiwin.athena.ptm.sdk.meta.dto.response;

import lombok.*;
import lombok.experimental.SuperBuilder;

import java.time.LocalDateTime;

/**
 * PTM 任务卡列表 中的 任务卡数据
 */
@Setter
@Getter
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class PtmTaskCardItemRespDTO {

    private Long backlogId;
    private Long workItemId;
    private Long activityId;
    private Long taskId;
    private Long projectId;
    private Long projectCardId;
    private String performerId;
    private String performerName;
    private Integer performerType;
    /**
     * 是否是合并任务
     */
    private Boolean merge;

    private LocalDateTime createTime;

    /**
     * 待办所属租户id，这个待办是发给哪个租户的。
     */
    private String tenantId;

    /**
     * 待办的来源租户id。主要适用于跨租户的待办
     * <br>其他待办，这个值应该同 tenantId
     */
    private String fromTenantId;

    private String projectDefCode;
    private String projectDefName;
    private String projectName;

    private String taskName;
    private String taskType;
    private String taskDefPattern;
    private String taskDefCategory;
    private String taskDefExecuteType;
    private String taskDefCode;
    private String taskDefName;
    private LocalDateTime taskCreateTime;

    private String signReason;
    private LocalDateTime planEndTime;
    private String proxyToken;
    private String activityName;
    private String signType;
    private String bpmnType;
    private String bpmActivityId;
    private String bpmActivityName;

    private String targetTenantId;

    private Boolean closed;

    /**
     * 任务卡关闭时间
     */
    private LocalDateTime closedTime;
    /**
     * 任务卡所属任务关闭时间
     */
    private LocalDateTime taskClosedTime;

    /**
     * 被辅助租户
     */
    private String auxiliaryTenantId;
    /**
     * 被辅助租户名称
     */
    private String auxiliaryTenantName;

    /**
     * 格式："{"zh_CN":"xxx", "zh_TW": "xxxxx", "en_US": "xxxxxx"}"
     */
    private String taskWithName;

    /**
     * 格式："{"zh_CN":"xxx", "zh_TW": "xxxxx", "en_US": "xxxxxx"}"
     */
    private String taskDefWithName;

    /**
     * 引擎中是否有待处理  add by 6203
     */
    private Boolean engineHasWaittingData;

}
