package com.digiwin.athena.ptm.sdk.meta.dto.request;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.util.List;

/**
 * 批量-获取项目 记录详情
 *
 * @author gengwei
 * @since 2024/8/26 11:30
 */
@Setter
@Getter
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class ProjectTaskModelReqDTO {
    /**
     * 项目ID
     */
    private List<Long> idList;
    /**
     * 如果不需要data，传needData为false，目的优化ptm内存消耗
     * needData不传或者传true，ptm都是默认查data
     */
    private Boolean needData;
}
