package com.digiwin.athena.translater.sdk.meta.dto;

import com.digiwin.athena.common.sdk.manager.meta.dto.BaseResultDTO;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.meta.handler.JaResultParseHandler;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.SuperBuilder;
import org.springframework.http.HttpStatus;

import java.util.Map;

/**
 * iam 返回的数据格式
 *
 * @author yinhaiye
 * @since 2025/8/18 15:28
 */
@Setter
@Getter
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TranslateResultDTO<T> extends BaseResultDTO<T> implements JaResultParseHandler<T> {

    private Map<String, Object> profile;
    private String uuid;
    private Long duration;

    @Override
    public Boolean success() {
        if (JaStringUtil.isNotEmpty(this.getErrorCode())) {
            return false;
        } else {
            return null != this.getStatus() && 200 == this.getStatus();
        }
    }

    @Override
    public String code() {
        return getErrorCode();
    }

    @Override
    public String message() {
        return getErrorMessage();
    }

    @Override
    public T data() {
        return getResponse();
    }
}
