package com.digiwin.athena.translater.sdk.meta.dto.response;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.util.Map;

/**
 * 翻译接口返回response中data数据
 * @author yinhaiye
 * @since 2025/08/19 16:21
 */
@Setter
@Getter
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TranslateDataDTO implements Serializable {
    // language 调用/IDWTranslateService/translateCustom返回结构
    private Map<String, TranslateLangData> language;
    // lang 调用/IDWTranslateService/translateCustom返回结构
    private Map<String, TranslateLangData> lang;
    // 调用/IDWTranslateService/translate返回结构繁体
    private Map<String, String> zh2Hant;
    // 调用/IDWTranslateService/translate返回结构简体
    private Map<String, String> zh2Hans;

    /**
     * 翻译的国际化数据
     */
    @Setter
    @Getter
    public static class TranslateLangData {
        // 简体中文
        private String zh_CN;
        // 繁体中文
        private String zh_TW;
        // 英文默认使用简体中文
        private String zh_US;
    }
}
