/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.translater.sdk.manager;

import com.digiwin.athena.common.sdk.manager.util.DwHttpResultParseUtil;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import com.digiwin.athena.translater.sdk.meta.dto.TranslateResultDTO;
import com.digiwin.athena.translater.sdk.meta.dto.request.TranslateReqDTO;
import com.digiwin.athena.translater.sdk.meta.dto.response.TranslateDataDTO;
import com.digiwin.athena.translater.sdk.meta.dto.response.TranslateRespDTO;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.framework.meta.handler.JaResultParseHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.core.ParameterizedTypeReference;

public class TranslateManager {
    private static final ParameterizedTypeReference<TranslateResultDTO<TranslateRespDTO>> TRANSLATE_RESP_DTO_PARAMETERIZED_TYPE_REFERENCE = new ParameterizedTypeReference<TranslateResultDTO<TranslateRespDTO>>(){};
    private static final String TRANSLATE_API = TranslateManager.getTranslateUri() + "/IDWTranslateService/translate";
    private static final String TRANSLATE_CUSTOM_API = TranslateManager.getTranslateUri() + "/IDWTranslateService/translateCustom";
    private static final String zh_CN = "zh2Hans";
    private static final String zh_TW = "zh2Hant";
    private static final Pattern CHINESE_PATTERN = Pattern.compile("[\\u4e00-\\u9fa5]");

    private static String getTranslateUri() {
        return JaProperty.get((String)"translate.uri");
    }

    public static TranslateDataDTO translateCustom(List<TranslateReqDTO> reqDTOList) {
        if (JaCollectionUtil.isEmpty(reqDTOList)) {
            JaLog.warn((String)"translateCustom|\u7ffb\u8bd1\u5165\u53c2\u4e3a\u7a7a", (Object[])new Object[0]);
            return null;
        }
        String[] convertTypes = new String[]{zh_CN, zh_TW};
        TranslateRespDTO respDTO = (TranslateRespDTO)DwHttpResultParseUtil.parse((JaResultParseHandler)((JaResultParseHandler)DwSpringHttpUtil.post((String)TRANSLATE_CUSTOM_API, TranslateManager.getRequestBody(reqDTOList, convertTypes), TRANSLATE_RESP_DTO_PARAMETERIZED_TYPE_REFERENCE)));
        TranslateDataDTO translateDataDTO = respDTO.getData();
        if (JaCollectionUtil.isNotEmpty(translateDataDTO.getLang())) {
            translateDataDTO.getLang().values().forEach(item -> item.setZh_US(item.getZh_CN()));
        } else {
            translateDataDTO.setLang(TranslateManager.getTranslateLangDataByParam(reqDTOList));
        }
        if (JaCollectionUtil.isNotEmpty(translateDataDTO.getLanguage())) {
            translateDataDTO.getLanguage().values().forEach(item -> item.setZh_US(item.getZh_CN()));
        } else {
            translateDataDTO.setLanguage(TranslateManager.getTranslateLangDataByParam(reqDTOList));
        }
        List<TranslateReqDTO> noChineseList = TranslateManager.filterNonChineseList(reqDTOList);
        if (JaCollectionUtil.isNotEmpty(noChineseList)) {
            translateDataDTO.getLang().putAll(TranslateManager.getTranslateLangDataByParam(noChineseList));
            translateDataDTO.getLanguage().putAll(TranslateManager.getTranslateLangDataByParam(noChineseList));
        }
        return translateDataDTO;
    }

    public static Map<String, String> translateCN(List<TranslateReqDTO> reqDTOList) {
        if (JaCollectionUtil.isEmpty(reqDTOList)) {
            JaLog.warn((String)"translateCN|\u7ffb\u8bd1\u5165\u53c2\u4e3a\u7a7a", (Object[])new Object[0]);
            return null;
        }
        String[] convertTypes = new String[]{zh_CN};
        TranslateRespDTO respDTO = (TranslateRespDTO)DwHttpResultParseUtil.parse((JaResultParseHandler)((JaResultParseHandler)DwSpringHttpUtil.post((String)TRANSLATE_API, TranslateManager.getRequestBody(reqDTOList, convertTypes), TRANSLATE_RESP_DTO_PARAMETERIZED_TYPE_REFERENCE)));
        return respDTO.getData().getZh2Hans();
    }

    public static Map<String, String> translateTW(List<TranslateReqDTO> reqDTOList) {
        if (JaCollectionUtil.isEmpty(reqDTOList)) {
            JaLog.warn((String)"translateTW|\u7ffb\u8bd1\u5165\u53c2\u4e3a\u7a7a", (Object[])new Object[0]);
            return null;
        }
        String[] convertTypes = new String[]{zh_TW};
        TranslateRespDTO respDTO = (TranslateRespDTO)DwHttpResultParseUtil.parse((JaResultParseHandler)((JaResultParseHandler)DwSpringHttpUtil.post((String)TRANSLATE_API, TranslateManager.getRequestBody(reqDTOList, convertTypes), TRANSLATE_RESP_DTO_PARAMETERIZED_TYPE_REFERENCE)));
        return respDTO.getData().getZh2Hant();
    }

    private static Map<String, Object> getRequestBody(List<TranslateReqDTO> reqDTOList, String[] convertTypes) {
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        HashMap<String, String> contentMap = new HashMap<String, String>(reqDTOList.size());
        for (TranslateReqDTO translateReqDTO : reqDTOList) {
            contentMap.put(translateReqDTO.getFieldName(), translateReqDTO.getFieldValue());
        }
        requestMap.put("content", contentMap);
        requestMap.put("convertTypes", convertTypes);
        return requestMap;
    }

    private static List<TranslateReqDTO> filterNonChineseList(List<TranslateReqDTO> reqDTOList) {
        if (JaCollectionUtil.isEmpty(reqDTOList)) {
            return Collections.emptyList();
        }
        ArrayList<TranslateReqDTO> result = new ArrayList<TranslateReqDTO>();
        for (TranslateReqDTO reqDTO : reqDTOList) {
            if (CHINESE_PATTERN.matcher(reqDTO.getFieldValue()).find()) continue;
            result.add(reqDTO);
        }
        return result;
    }

    private static Map<String, TranslateDataDTO.TranslateLangData> getTranslateLangDataByParam(List<TranslateReqDTO> reqDTOList) {
        if (JaCollectionUtil.isEmpty(reqDTOList)) {
            return Collections.emptyMap();
        }
        HashMap<String, TranslateDataDTO.TranslateLangData> result = new HashMap<String, TranslateDataDTO.TranslateLangData>(reqDTOList.size());
        for (TranslateReqDTO translateReqDTO : reqDTOList) {
            TranslateDataDTO.TranslateLangData value = new TranslateDataDTO.TranslateLangData();
            value.setZh_CN(translateReqDTO.getFieldValue());
            value.setZh_US(translateReqDTO.getFieldValue());
            value.setZh_TW(translateReqDTO.getFieldValue());
            result.put(translateReqDTO.getFieldName(), value);
        }
        return result;
    }
}

