/*
 * FileName: EntityMetaObjectHandler
 * Author:   DONGSK
 * Datetime: 2021/11/11 20:18
 * Description:
 * History:
 * 作者姓名 --修改时间 --版本号--描述
 */
package com.digiwin.athena.abt.application.configuration;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.digiwin.athena.abt.core.meta.dto.BaseEntity;
import org.apache.ibatis.reflection.MetaObject;

import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.Map;

/**
 * EntityMetaObjectHandler
 *
 * @author wzq
 * @date 2025/04/01
 * @since 1.0.0
 */
public class AbtEntityMetaObjectHandler implements MetaObjectHandler {
    private static final String F_UPDATED_TIME = "modifyDate";
    private static final String F_CREATE_TIME = "createDate";

    @Override
    public void insertFill(MetaObject metaObject) {
        if (checkMetaObject(metaObject)) {
            LocalDateTime date = LocalDateTime.now();
            setFieldValByName(F_CREATE_TIME, date, metaObject);
            setFieldValByName(F_UPDATED_TIME, date, metaObject);
        }
    }

    private boolean checkMetaObject(MetaObject metaObject) {
        boolean isDataEntity = false;
        if (metaObject.getOriginalObject() instanceof Map) {
            Map<String, Object> map = (Map<String, Object>) metaObject.getOriginalObject();
            Iterator<String> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String next = iterator.next();
                if (map.get(next) instanceof BaseEntity) {
                    isDataEntity = true;
                    break;
                }
            }
        }
        return isDataEntity || metaObject.getOriginalObject() instanceof BaseEntity;
    }

    @Override
    public void updateFill(MetaObject metaObject) {
        if (checkMetaObject(metaObject)) {
            setFieldValByName(F_UPDATED_TIME, LocalDateTime.now(), metaObject);
        }
    }

}