package com.digiwin.athena.abt.application.configuration;

import com.baomidou.mybatisplus.core.injector.AbstractMethod;
import com.baomidou.mybatisplus.core.injector.DefaultSqlInjector;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.extension.injector.methods.InsertBatchSomeColumn;

import java.util.List;

/**
 * @description: 新增 MasterSqlInjector 类继承于 DefaultSqlInjector，负责将所有通用的 Mapper方法 的定义类收集起来，后续将使用这些方法定义类为每一个具体的 Mapper 添加通用方法
 * @author: dongwh
 * @date: 2023/10/18 14:11
 */
public class AbtInsertBatchSqlInjector extends DefaultSqlInjector {
    @Override
    public List<AbstractMethod> getMethodList(Class<?> mapperClass, TableInfo tableInfo) {
        // super.getMethodList() 保留 Mybatis Plus 自带的方法
        List<AbstractMethod> methodList = super.getMethodList(mapperClass, tableInfo);
        // 添加自定义方法：批量插入，方法名为 insertBatchSomeColumn 注意：只在mysql下测试过
        methodList.add(new InsertBatchSomeColumn());
        return methodList;
    }
}
