package com.digiwin.athena.abt.application.configuration;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.internal.MongoClientImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;

@Configuration
public class BkMongoTemplateConfig {
    @Value("${spring.data.mongodb.uri}")
    private String uriLog;

    @Value("${spring.data.mongodb.atmcBkDatabase}")
    private String atmcBkDatabase;

    @Value("${spring.data.mongodb.atmcCardBusinessMessage:atmc_card_business_message}")
    private String atmcCardBusinessMessage;

    @Value("${spring.data.mongodb.atmcTempData}")
    private String atmcTempData;

    @Bean("atmcBkDatabaseMongoTemplate")
    @ConditionalOnMissingBean(name = "atmcBkDatabaseMongoTemplate")
    public MongoTemplate atmcBkDatabaseMongoTemplate() {
        MongoClient client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(uriLog)).build(), null);
        return new MongoTemplate(client, atmcBkDatabase);
    }

    @Bean("atmcCardBusinessMessageMongoTemplate")
    @ConditionalOnMissingBean(name = "atmcCardBusinessMessageMongoTemplate")
    public MongoTemplate atmcCardBusinessMessageMongoTemplate() {
        MongoClient client = new MongoClientImpl(MongoClientSettings.builder()
                .retryWrites(false)
                .applyConnectionString(new ConnectionString(uriLog))
                .build(), null);
        return new MongoTemplate(client, atmcCardBusinessMessage);
    }

    @Bean("atmcTempDataMongo")
    @ConditionalOnMissingBean(name = "atmcTempDataMongo")
    public MongoTemplate atmcTempDataMongo() {
        MongoClient client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(uriLog)).build(), null);
        return new MongoTemplate(client, atmcTempData);
    }
}
