package com.digiwin.athena.abt.application.configuration;

import com.digiwin.athena.abt.application.service.abt.migration.mq.ConfirmCallbackService;
import com.digiwin.athena.abt.application.utils.NetUtil;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;
import java.util.Map;

/**
 * @ClassName DirectRabbitConfig
 * @Description rabbit配置类
 * @Author zhuangli
 * @Date 2021/4/2 9:57
 * @Version 1.0
 **/
@Configuration
public class DirectRabbitConfig {

    public static final String QUEUE_NAME = "AbtImportDataEntryQueue-" + NetUtil.getLocalMac();
    public static final String EXCHANGE_NAME = "AbtImportDataEntryExchange";
    public static final String ROUTING_NAME = NetUtil.getLocalMac();
    public static final String DEAD_LETTER_EXCHANGE_NAME = "AbtImportDataEntryDeadLetterExchange";
    public static final String DEAD_LETTER_QUEUE_NAME = "AbtImportDataEntryDeadLetterQueue-" + NetUtil.getLocalMac();
    public static final String DEAD_LETTER_ROUTING_NAME = NetUtil.getLocalMac();
    public static final String MANUAL_DEAD_LETTER_EXCHANGE_NAME = "AbtImportManualDataEntryDeadLetterExchange";
    public static final String MANUAL_DEAD_LETTER_QUEUE_NAME = "AbtImportManualDataEntryDeadLetterQueue";
    public static final String MANUAL_DEAD_LETTER_ROUTING_NAME = "Manual";


    public static final String ERROR_TABLE_EXCHANGE_NAME = "AbtImportErrorTableExchange";

    /**
     * 异步导出文件MQ
     */
    public static final String EXPORT_FILE_QUEUE_NAME = "AbtExportFileQueue-" + NetUtil.getLocalMac();

    /**
     * 异步导出文件交换机
     */
    public static final String EXPORT_FILE_EXCHANGE_NAME = "AbtExportFileExchange";

    /**
     * 异步导出文件MQ
     */
    public static final String EXPORT_HISTORY_DATA_FILE_QUEUE_NAME = "AbtExportHistoryDataFileQueue-" + NetUtil.getLocalMac();

    /**
     * 历史项目任务，异步导出文件交换机
     */
    public static final String EXPORT_HISTORY_DATA_FILE_EXCHANGE_NAME = "AbtExportHistoryDataFileExchange";

    /**
     * 历史项目任务明细，异步导出文件队列
     */
    public static final String EXPORT_HISTORY_PROJECT_TASK_DETAIL_QUEUE_NAME = "AbtExportHistoryProjectTaskDetailQueue-" + NetUtil.getLocalMac();

    /**
     * 历史项目任务明细，异步导出文件交换机
     */
    public static final String EXPORT_HISTORY_PROJECT_TASK_DETAIL_EXCHANGE_NAME = "AbtExportHistoryProjectTaskDetailExchange";

    /**
     * 历史项目任务明细，异步导出 RoutingKey
     */
    public static final String EXPORT_HISTORY_PROJECT_TASK_DETAIL_ROUTING_KEY = "AbtExportHistoryProjectTaskDetailRoutingKey" + NetUtil.getLocalMac();

    /**
     * 历史项目任务明细，异步导出，死信交换机名称
     */

    public static final String EXPORT_HISTORY_PROJECT_TASK_DETAIL_DEAD_LETTER_EXCHANGE_NAME = "AbtExportHistoryProjectTaskDetailDeadLetterExchange";

    /**
     * 历史项目任务明细，异步导出，死信队列名称
     */
    public static final String EXPORT_HISTORY_PROJECT_TASK_DETAIL_DEAD_LETTER_QUEUE_NAME = "AbtExportHistoryProjectTaskDetailDeadLetterQueue-" + NetUtil.getLocalMac();

    /**
     * 历史项目任务明细，异步导出，死信 RoutingKey
     */
    public static final String EXPORT_HISTORY_PROJECT_TASK_DETAIL_DEAD_LETTER_ROUTING_KEY = "ExportHistoryProjectTaskDetailDeadLetterRoutingKey" + NetUtil.getLocalMac();


    /**
     * 异步导入文件
     */
    public static final String IMPORT_FILE_QUEUE_NAME = "AsyncImportFileQueue-" + NetUtil.getLocalMac();


    /**
     * 异步导入文件交换机
     */
    public static final String IMPORT_FILE_EXCHANGE_NAME = "AsyncImportFileExchange";


    /**
     * 异步导入文件交换机
     */
    @Bean
    public String dataEntryQueueNameAsync() {
        return IMPORT_FILE_QUEUE_NAME;
    }

    @Bean
    public DirectExchange createAsyncDirectExchange() {
        return new DirectExchange(IMPORT_FILE_EXCHANGE_NAME,true,false);
    }
    @Bean
    public Queue createAsyncDirectQueue() {
        Map<String, Object> args = new HashMap<>(6);
        // 消息过期时间为120秒
        args.put("x-message-ttl", 120 * 1000);
        // 队列过期时间360秒
        args.put("x-expires", 360 * 1000);
        return new Queue(IMPORT_FILE_QUEUE_NAME, true, false, false, args);
    }
    @Bean
    public Binding bindingAsyncDataEntryDirect(@Qualifier("createAsyncDirectQueue") Queue queue,
                                          @Qualifier("createAsyncDirectExchange") DirectExchange exchange) {
        return BindingBuilder.bind(queue).to(exchange).with(ROUTING_NAME);
    }



    /** AbtDataEntryQueue **/
    @Bean
    public String dataEntryQueueName() {
        return QUEUE_NAME;
    }
    @Bean
    public DirectExchange createDirectExchange() {
        return new DirectExchange(EXCHANGE_NAME,true,false);
    }
    @Bean
    public Queue createDirectQueue() {
        Map<String, Object> args = new HashMap<>(6);
        args.put("x-dead-letter-exchange", DEAD_LETTER_EXCHANGE_NAME);
        args.put("x-dead-letter-routing-key", DEAD_LETTER_ROUTING_NAME);
        // 消息过期时间为120秒
        args.put("x-message-ttl", 120 * 1000);
        // 队列过期时间360秒
        args.put("x-expires", 360 * 1000);
        return new Queue(QUEUE_NAME, true, false, false, args);
    }
    @Bean
    public Binding bindingDataEntryDirect(@Qualifier("createDirectQueue") Queue queue,
                                          @Qualifier("createDirectExchange") DirectExchange exchange) {
        return BindingBuilder.bind(queue).to(exchange).with(ROUTING_NAME);
    }


    /** ExportFileQueue **/
    @Bean
    public String exportFileQueueName() {
        return EXPORT_FILE_QUEUE_NAME;
    }
    @Bean
    public DirectExchange createExportFileExchange() {
        return new DirectExchange(EXPORT_FILE_EXCHANGE_NAME,true,false);
    }
    @Bean
    public Queue createExportFileQueue() {
        Map<String, Object> args = new HashMap<>(6);
        // 消息过期时间120秒
        args.put("x-message-ttl", 120 * 1000);
        // 队列过期时间360秒
        args.put("x-expires", 360 * 1000);
        return new Queue(EXPORT_FILE_QUEUE_NAME, true, false, false, args);
    }
    @Bean
    public Binding bindingExportFileDirect(@Qualifier("createExportFileQueue") Queue queue,
                                           @Qualifier("createExportFileExchange") DirectExchange exchange) {
        return BindingBuilder.bind(queue).to(exchange).with(ROUTING_NAME);
    }

    @Bean
    public String exportHistoryDataFileQueueName() {
        return EXPORT_HISTORY_DATA_FILE_QUEUE_NAME;
    }
    @Bean
    public DirectExchange createExportHistoryDataFileExchange() {
        return new DirectExchange(EXPORT_HISTORY_DATA_FILE_EXCHANGE_NAME,true,false);
    }
    @Bean
    public Queue createExportHistoryDataFileQueue() {
        Map<String, Object> args = new HashMap<>(6);
        // 消息过期时间120秒
        args.put("x-message-ttl", 120 * 1000);
        // 队列过期时间360秒
        args.put("x-expires", 360 * 1000);
        return new Queue(EXPORT_HISTORY_DATA_FILE_QUEUE_NAME, true, false, false, args);
    }
    @Bean
    public Binding bindingExportHistoryDataFileDirect(@Qualifier("createExportHistoryDataFileQueue") Queue queue,
                                                      @Qualifier("createExportHistoryDataFileExchange") DirectExchange exchange) {
        return BindingBuilder.bind(queue).to(exchange).with(ROUTING_NAME);
    }

    /** AbtDataEntryDeadLetterQueue **/
    @Bean
    public String dataEntryDeadLetterQueueName() {
        return DEAD_LETTER_QUEUE_NAME;
    }
    @Bean
    public DirectExchange dataEntryDeadLetterExchange(){
        return new DirectExchange(DEAD_LETTER_EXCHANGE_NAME);
    }
    @Bean
    public Queue dataEntryDeadLetterQueue(){
        Map<String, Object> args = new HashMap<>(6);
        args.put("x-dead-letter-exchange", MANUAL_DEAD_LETTER_EXCHANGE_NAME);
        args.put("x-dead-letter-routing-key", MANUAL_DEAD_LETTER_ROUTING_NAME);
        // 消息过期时间240秒
        args.put("x-message-ttl", 240 * 1000);
        // 队列过期时间360秒
        args.put("x-expires", 360 * 1000);
        return new Queue(DEAD_LETTER_QUEUE_NAME, true, false, false, args);
    }
    @Bean
    public Binding bindingDataEntryDeadLetterDirect(@Qualifier("dataEntryDeadLetterQueue") Queue queue,
                                                    @Qualifier("dataEntryDeadLetterExchange") DirectExchange exchange) {
        return BindingBuilder.bind(queue).to(exchange).with(DEAD_LETTER_ROUTING_NAME);
    }


    /** AbtManualDataEntryDeadLetterQueue **/
    @Bean
    public Queue manualDataEntryDeadLetterQueue(){
        return new Queue(MANUAL_DEAD_LETTER_QUEUE_NAME);
    }
    @Bean
    public DirectExchange manualDataEntryDeadLetterExchange(){
        return new DirectExchange(MANUAL_DEAD_LETTER_EXCHANGE_NAME);
    }
    @Bean
    public Binding bindingManualDataEntryDeadLetterDirect(@Qualifier("manualDataEntryDeadLetterQueue") Queue queue,
                                                          @Qualifier("manualDataEntryDeadLetterExchange") DirectExchange exchange) {
        return BindingBuilder.bind(queue).to(exchange).with(MANUAL_DEAD_LETTER_ROUTING_NAME);
    }

    @Bean
    public DirectExchange createErrorTableExchange() {
        return new DirectExchange(ERROR_TABLE_EXCHANGE_NAME,true,false);
    }

    @Bean
    public ConfirmCallbackService confirmCallbackService() {
        return new ConfirmCallbackService();
    }

    @Bean
    public String exportHistoryProjectTaskDetailQueueName() {
        return EXPORT_HISTORY_PROJECT_TASK_DETAIL_QUEUE_NAME;
    }

    @Bean
    public DirectExchange createExportHistoryProjectTaskDetailExchange() {
        return new DirectExchange(EXPORT_HISTORY_PROJECT_TASK_DETAIL_EXCHANGE_NAME, true, false);
    }

    @Bean
    public Queue createExportHistoryProjectTaskDetailQueue() {
        Map<String, Object> args = new HashMap<>();
        // 消息过期时间1小时
        args.put("x-message-ttl", 3600 * 1000);
        // 队列过期时间2小时
        args.put("x-expires", 7200 * 1000);
        // 设置死信交换机和路由键
        args.put("x-dead-letter-exchange", EXPORT_HISTORY_PROJECT_TASK_DETAIL_DEAD_LETTER_EXCHANGE_NAME);
        args.put("x-dead-letter-routing-key", EXPORT_HISTORY_PROJECT_TASK_DETAIL_DEAD_LETTER_ROUTING_KEY);
        return new Queue(EXPORT_HISTORY_PROJECT_TASK_DETAIL_QUEUE_NAME, true, false, false, args);
    }

    @Bean
    public Binding bindingExportHistoryProjectTaskDataFileDirect(@Qualifier("createExportHistoryProjectTaskDetailQueue") Queue queue,
                                                                 @Qualifier("createExportHistoryProjectTaskDetailExchange") DirectExchange exchange) {
        return BindingBuilder.bind(queue).to(exchange).with(EXPORT_HISTORY_PROJECT_TASK_DETAIL_ROUTING_KEY);
    }

    @Bean
    public String exportHistoryProjectTaskDetailDeadLetterQueueName() {
        return EXPORT_HISTORY_PROJECT_TASK_DETAIL_DEAD_LETTER_QUEUE_NAME;
    }

    @Bean
    public DirectExchange exportHistoryProjectTaskDetailDeadLetterExchange() {
        return new DirectExchange(EXPORT_HISTORY_PROJECT_TASK_DETAIL_DEAD_LETTER_EXCHANGE_NAME);
    }

    @Bean
    public Queue exportHistoryProjectTaskDetailDeadLetterQueue() {
        Map<String, Object> args = new HashMap<>();
        // 消息过期时间半小时
        args.put("x-message-ttl", 1800 * 1000);
        // 队列过期时间1小时
        args.put("x-expires", 3600 * 1000);
        return new Queue(EXPORT_HISTORY_PROJECT_TASK_DETAIL_DEAD_LETTER_QUEUE_NAME, true, false, false, args);
    }

    @Bean
    public Binding bindingExportHistoryProjectTaskDetailDeadLetterDirect(@Qualifier("exportHistoryProjectTaskDetailDeadLetterQueue") Queue queue,
                                                                         @Qualifier("exportHistoryProjectTaskDetailDeadLetterExchange") DirectExchange exchange) {
        return BindingBuilder.bind(queue).to(exchange).with(EXPORT_HISTORY_PROJECT_TASK_DETAIL_DEAD_LETTER_ROUTING_KEY);
    }

//    @Bean
//    public RabbitTemplate rabbitTemplate(@Autowired CachingConnectionFactory factory) {
//        RabbitTemplate rabbitTemplate = new RabbitTemplate(factory);
//        rabbitTemplate.setConfirmCallback(confirmCallbackService());
//        return rabbitTemplate;
//    }

}
