package com.digiwin.athena.abt.application.configuration;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
//import com.jugg.agile.middleware.db.datasource.JaDataSourceFactory;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import javax.sql.DataSource;

/**
 * 基础资料导入导出数据源配置类
 */
@Configuration
//@DependsOn("jaDataSourceConfiguration")
@EnableTransactionManagement
//@MapperScan(basePackages = {"com.digiwin.athena.abt.infrastructure.mapper"}, sqlSessionFactoryRef = "importStatisticsSqlSessionFactory")
@MapperScan(basePackages = {"com.digiwin.athena.abt.infrastructure.mapper.biz.migration.abt"}, sqlSessionFactoryRef = "importStatisticsSqlSessionFactory", markerInterface = BaseMapper.class)
public class ImportStatisticsDataSourceConfig {

    /**
     * 数据源名称
     */
    private static final String DATASOURCE_NAME = "importStatisticsDataSource";

    /**
     * 基础资料导入导出数据源
     */
    private static final String IMPORT_DATASOURCE_PREFIX = "spring.datasource.druid.import";

    @Bean(name = DATASOURCE_NAME)
    @ConfigurationProperties(prefix = IMPORT_DATASOURCE_PREFIX)
    public DruidDataSource importStatisticsDataSource() {
        return new DruidDataSource();
    }

    @Bean(name = "importStatisticsSqlSessionFactory")
    public SqlSessionFactory importStatisticsSqlSessionFactory(@Qualifier(DATASOURCE_NAME) DataSource dataSource) throws Exception {
        MybatisSqlSessionFactoryBean bean = new MybatisSqlSessionFactoryBean();
        bean.setDataSource(dataSource);
        bean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath:mapper/importstatistics/*.xml"));
        // bean.setPlugins(new Interceptor[] {xxx}); // 设置mybatis插件
        return bean.getObject();
    }

    @Bean
    DataSourceTransactionManager transactionManager(Environment environment, @Qualifier(DATASOURCE_NAME) DataSource dataSource,
                                                    ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
        DataSourceTransactionManager transactionManager = createTransactionManager(environment, dataSource);
        transactionManagerCustomizers.ifAvailable((customizers) -> customizers.customize(transactionManager));
        return transactionManager;
    }

    private DataSourceTransactionManager createTransactionManager(Environment environment, @Qualifier(DATASOURCE_NAME) DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean(name = "importStatisticsSqlSessionTemplate")
    public SqlSessionTemplate importStatisticsSqlSessionTemplate(@Qualifier("importStatisticsSqlSessionFactory") SqlSessionFactory sqlSessionFactory) throws Exception {
        return new SqlSessionTemplate(sqlSessionFactory);
    }
}
