package com.digiwin.athena.abt.application.configuration;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.internal.MongoClientImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;

@Configuration
public class MongoTemplateConfig {
    @Value("${spring.data.mongodb-api-log.uri}")
    private String uriLog;
    @Value("${spring.data.mongodb-api-log.database}")
    private String databaseLog;

    @Bean("mongoTemplate")
    public MongoTemplate mongoTemplate() {
        MongoClient client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(uriLog)).build(), null);
        return new MongoTemplate(client, databaseLog);
    }
}
