package com.digiwin.athena.abt.application.configuration;

import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.params.SetParams;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;

@Configuration
@Slf4j
public class SnowflakeIdConfig implements DisposableBean {

    // 定时任务运行周期：5分钟，redis续期时间
    private static final long FIXED_RATE = 5 * 60 * 1000L;

    //redis过期时间，8分钟
    private final long expire = 8 * 60 * 1000L;

    private static final String POSTPONE_EXPIRE = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('PEXPIRE', KEYS[1], ARGV[2]) else return '0' end";
    private static final String DEL_LOCK = "if redis.call('get',KEYS[1]) == ARGV[1] then return redis.call('del',KEYS[1]) else return 0 end";

    private String lockKey = null;
    private String hostAddress = null;
    private static final Long POSTPONE_SUCCESS = 1L;

    private long workerId = 0;
    private long dataCenterId = 0;

    @Autowired
    private RedisTemplate redisTemplate;


    /**
     * 锁定 雪花算法的workerId
     */
    @Scheduled(fixedRate = FIXED_RATE)
    public void lockWorkerId() {
        try {
            if (StringUtils.isBlank(lockKey)) {
                InetAddress localHost = InetAddress.getLocalHost();
                hostAddress = localHost.getHostAddress();
                String key = null;

                for (int j = 1; j < 7; j++) {
                    for (int i = 1; i < 7; i++) {
//                for (int i = 0; i < 8; i++) {
                        key = String.format("abt:Snowflake:WorkerId:%s:%s", i , j);
                        if (this.exePostpone(key, hostAddress, expire) || lockWorkerId(key, hostAddress)) {
                            this.workerId = i;
                            this.dataCenterId = j;
                            this.lockKey = key;
                            SnowflakeIdWorker.getInstance().init(this.dataCenterId, this.workerId);
                            log.warn("[SnowflakeIdConfig] lockKey:{}", lockKey);
                            break;
                        }
                    }
                    if (this.dataCenterId != 0) {
                        break;
                    }
                }
                if (this.dataCenterId == 0 || this.workerId == 0) {
                    System.exit(1);
                }
            } else {
                exePostpone(this.lockKey, this.hostAddress, this.expire);
            }
        } catch (Exception e) {
            log.warn("[SnowflakeIdConfig] error:{}", e);
        }
    }

    /**
     * 续期
     *
     * @param key
     * @param value
     * @param expire
     * @return
     */
    private boolean exePostpone(String key, String value, long expire) {
        Boolean isOK = Boolean.FALSE;
        try {
            isOK = (Boolean) redisTemplate.execute((RedisCallback<Boolean>) redisConnection -> {
                List<String> keys = new ArrayList<>();
                keys.add(key);
                List<String> params = new ArrayList<>();
                params.add(value);
                params.add(String.valueOf(expire));
                Jedis jedis = (Jedis) redisConnection.getNativeConnection();
                Object result = jedis.eval(POSTPONE_EXPIRE, keys, params); // 单位S
                if (POSTPONE_SUCCESS.equals(result)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            });
        } catch (Exception e) {
            log.warn("[SnowflakeIdConfig] postPone error:{}", e);
        }
        return Boolean.TRUE.equals(isOK);
    }

    /***
     * 锁定 机器码
     */
    private boolean lockWorkerId(String key, String value) {
        Boolean locked = (Boolean) redisTemplate.execute((RedisCallback<Boolean>) redisConnection -> {
            Jedis jedis = (Jedis) redisConnection.getNativeConnection();
            SetParams setParams = new SetParams().nx().px(expire);
            String result = jedis.set(key, value, setParams);
            if ("OK".equals(result)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        });
        return Boolean.TRUE.equals(locked);
    }

    @Override
    public void destroy() throws Exception {
        //释放redis锁
        try {
            redisTemplate.execute((RedisCallback<Boolean>) redisConnection -> {
                List<String> keys = new ArrayList<>();
                keys.add(this.lockKey);
                List<String> params = new ArrayList<>();
                params.add(this.hostAddress);
                params.add(String.valueOf(expire));
                Jedis jedis = (Jedis) redisConnection.getNativeConnection();
                Object result = jedis.eval(DEL_LOCK, keys, params); // 单位S
                return Boolean.TRUE;
            });
        } catch (Exception e) {
            log.warn("[SnowflakeIdConfig] del error:{}", e);
        }
    }
}
