package com.digiwin.athena.abt.application.configuration;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.ThreadPoolExecutor;

@Configuration
public class ThreadPoolConfig {

    // 核心线程池大小
    @Value("${threadPool.refreshCard.corePoolSize:5}")
    private int corePoolSize;

    // 最大可创建的线程数
    @Value("${threadPool.refreshCard.maxPoolSize:10}")
    private int maxPoolSize;

    @Value("${threadPool.refreshCard.queueCapacity:200}")
    private int queueCapacity;

    // 线程池维护线程所允许的空闲时间
    @Value("${threadPool.refreshCard.queueCapacity:300}")
    private int keepAliveSeconds;

    @Bean(name = "threadPoolRefreshCardTaskExecutor")
    public ThreadPoolTaskExecutor threadPoolRefreshCardTaskExecutor()
    {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setMaxPoolSize(maxPoolSize);
        executor.setCorePoolSize(corePoolSize);
        executor.setQueueCapacity(queueCapacity);
        executor.setKeepAliveSeconds(keepAliveSeconds);
        // 线程池对拒绝任务(无线程可用)的处理策略
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        return executor;
    }
}
