package com.digiwin.athena.abt.application.dto.migration.abt.api;

import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;


/**
 * 导出历史项目任务参数
 *
 * @author xuhx
 * @date 2025/5/16
 */
@Data
public class DownloadHistoryProjectTaskParamDTO implements Serializable {

    private static final long serialVersionUID = 5665653751447572281L;
    /**
     * 归档类型。hot-热库数据；archive-已归档数据；all-不确定；
     */
    private String archiveRouteKey;

    /**
     * 导出生成的zip文件名。可以下载
     */
    private String fileName;

    /**
     * 需要导出的项目/任务列表
     */
    private List<DownloadHistoryProjectTaskSubParamDTO> list;

    @Getter
    @Setter
    public static class DownloadHistoryProjectTaskSubParamDTO {

        /**
         * 导出的类型。0-业务数据录入；1-历史项目任务列表；2-导出任务；3-导出项目；
         */
        private String type;

        /**
         * 导出的历史项目卡(projectCard)或任务卡(backlog)id
         */
        private Long id;

        /**
         * 项目或任务所属KM定义的code
         */
        private String code;

        /**
         * 项目或任务所属KM定义的name
         */
        private String name;

        /**
         * 当前项目或任务在zip包中的文件名。仅查看，不提供单个文件下载。
         * 便于用户区分这一批导出了哪些任务或项目
         */
        private String fileName;

        private String proxyToken;

        private String tenantId;
    }
}

