package com.digiwin.athena.abt.application.dto.migration.abt.api;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @ClassName ImportStatisticsDTO
 * @Description TODO
 * @Author zhuangli
 * @Date 2021/4/12 11:30
 * @Version 1.0
 **/
@Data
public class ImportStatisticsDTO {

    private Long id;
    private String masterId;
    private String activityId;
    private String activityName;
    private String userId;
    private String userJson;
    private String userToken;
	private String locale;
    private String actionId;
    private Integer succeededNum;
    private Integer processingNum;
    private Integer failedNum;
    // 错误个数
    private Integer errorNum;
    private String failedUrl;
    private Integer republished;
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;
    private String routerKey;
    /**
     * 业务参数数据
     */
    private String actionInfo;

    /**
     * 查询导入类型，0:业务数据录入，1:历史项目任务，2:任务，3:项目
     */
    private Integer type;

    /**
     * 导入模式 insert , update, insertOrUpdate
     */
    private String importModel;

    /**
     * 查询总数
     */
    private Integer queryPageTotal;

    /**
     *  消耗时间 单位秒
     */
    private String consumeTime;
}
