package com.digiwin.athena.abt.application.dto.migration.abt.api;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class MidWareResponse<T>{
    private Integer code;
    private String message;
    private T data;
    private Boolean success;

    public static MidWareResponse ok(){
        return MidWareResponse.builder().code(200).success(true).build();
    }

    public static <T> MidWareResponse ok(T data){
        return MidWareResponse.builder().code(200).success(true).data(data).build();
    }

    public static MidWareResponse failed(String msg){
        return MidWareResponse.builder().code(500).success(false).message(msg).build();
    }
}
