package com.digiwin.athena.abt.application.dto.migration.abt.api;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * RefreshCardMessageCompensateDTO Description
 *
 * @author majianfu
 * @date 2023/4/11
 * @since
 */
@Data
public class RefreshCardMessageCompensateDTO {
    /**
     * 租户id
     */
    @NotBlank
    private String tenantId;

    /**
     * 作业code
     */
    @NotBlank
    private String taskCode;

    /**
     * 必填，卡片类型
     */
    @NotNull
    private Integer cardType;

    /**
     * 任务卡id列表
     */
    @NotEmpty
    private List<Long> cardIds;

    /**
     *  刷新类型(默认 代表刷新所有)  business(只刷新标签分组筛选排序)
     */
    private String refreshCardType;
}
