package com.digiwin.athena.abt.application.dto.migration.abt.api;

import com.digiwin.athena.abt.core.ie.excel.reader.IExcelParam;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import lombok.Data;

import java.util.Set;

/**
 * @ClassName UploadParamDTO
 * @Description TODO
 * @Author zhuangli
 * @Date 2021/4/16 10:19
 * @Version 1.0
 **/
@Data
public class UploadParamDTO implements IExcelParam {
    private String actionId;
    private String activityId;
    private String userId;

    /**
     * 业务参数数据
     */
    private ActionInfoDTO actionInfo;

    /**
     * upload接口前端会传入单头必填项
     */
    private Set<String> requiredFields;

    /**
     * republish接口前端会传入masterId、tableDTO
     */
    private String masterId;
    private TableDTO tableDTO;

    /**
     * 应用 code
     */
    private String application;

    /**
     * 导入模式 insert , update, insertOrUpdate
     */
    private String importModel;

    /**
     * dmc文件url
     */
    private String fileUrl;

    /**
     * 上传文件的用户信息
     */
    private AuthoredUser authoredUser;

    /**
     * 文件名
     */
    private String fileName;

    /**
     * 上传文件的token
     */
    private String securityToken;

    /**
     * 文件唯一标识
     */
    private String fileUid ;
}