package com.digiwin.athena.abt.application.dto.migration.abt.bk;

import com.digiwin.athena.abt.application.dto.migration.abt.event.EventBaseDTO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.sf.json.JSONObject;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class ActivityBusinessKeyDTO extends EventBaseDTO {
    /**
     * task.id
     * ptmProject.id
     * ptm 项目实例id
     */
    private Long subTaskId;
    /**
     * task.tenantId
     * 租户id
     */
    private String tenantId;
    /**
     * task.tmTaskId
     * ptmProject.projectDefCode
     * kg项目定义code
     */
    private String tmTaskId;
    /**
     * bpmActivityStep.state
     * ptmTaskActivity.state
     * ptm 活动状态
     */
    private Integer state;
    /**
     * bpmActivityStep.id
     * ptmTaskActivity.id
     * ptm 活动id
     */
    private Long activityId;
    /**
     * bpmActivity.businessUnit
     * ptmTask.businessUnit
     * ptm 任务业务单元
     */
    private JSONObject businessUnit;
    /**
     * bpmActivity.data
     * ptmTask.data
     * BPM传过来的查询数据，优先使用 bpm_activity_step.data
     * 如果 bpm_activity_step.data 没有值，或没有对应的 bpm_activity_step 记录，则使用该 data
     */
    private JSONObject data;
    /**
     * activityDefine.tmActivityId
     * ptmTask.taskDefCode
     * kg 任务定义code
     */
    private String tmActivityId;
    /**
     * ptmTask.data
     */
    private JSONObject bpmData;
    /**
     * bpmActivityWorkitem.id
     * ptmTaskActivityItem.id
     * ptm 事项id
     */
    private Long workitemId;

    private Boolean closed;
}
