package com.digiwin.athena.abt.application.dto.migration.abt.bk;

import com.digiwin.athena.abt.application.dto.migration.abt.event.EventBaseDTO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.sf.json.JSONObject;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class ProjectBusinessKeyDTO extends EventBaseDTO {
    /**
     * task.id
     * ptmProject.id
     * ptm 项目卡id
     */
    private Long id;
    /**
     * task.tenantId
     * 租户id
     */
    private String tenantId;
    /**
     * task.tmTaskId
     * ptmProject.projectDefCode
     * kg项目定义code
     */
    private String tmTaskId;
    /**
     * task.state
     * ptmProject.state
     * ptm 项目状态
     */
    private Integer state;
    /**
     * ptm 来源单号
     */
    private String sourceIds;
    /**
     * task.businessUnit
     * ptmProject.businessUnit
     * ptm 项目业务单元
     */
    private JSONObject businessUnit;
    /**
     * bpmProcess.data
     * ptmTask.data
     * 项目备注
     */
    private JSONObject data;

    private Boolean closed;
}
