package com.digiwin.athena.abt.application.dto.migration.abt.event;

import com.digiwin.athena.abt.application.dto.migration.abt.inout.ImportStatistics;

import java.util.Date;
import java.util.UUID;

/**
 * @ClassName ImportSuccessEventFactory
 * @Description TODO
 * @Author zhuangli
 * @Date 2021/4/21 9:46
 * @Version 1.0
 **/
public class ImportSuccessEventFactory {

    public static ImportSuccessEvent produceByImportStatistics(ImportStatistics importStatistics) {
        ImportSuccessEvent importSuccessEvent = new ImportSuccessEvent();
        importSuccessEvent.setActivityId(importStatistics.getActivityId());
        importSuccessEvent.setActivityName(importStatistics.getActivityName());
        importSuccessEvent.setFailedNum(importStatistics.getFailedNum());
        importSuccessEvent.setSucceededNum(importStatistics.getSucceededNum());
        importSuccessEvent.setProcessingNum(importStatistics.getProcessingNum());
        importSuccessEvent.setErrorNum(importStatistics.getErrorNum());
        importSuccessEvent.setUserId(importStatistics.getUserId());
        importSuccessEvent.setUserToken(importStatistics.getUserToken());
        importSuccessEvent.setTimestamp(new Date());
        importSuccessEvent.setMasterId(importStatistics.getMasterId());
        importSuccessEvent.setId(UUID.randomUUID().toString());
        importSuccessEvent.setUserJson(importStatistics.getUserJson());
        return importSuccessEvent;
    }

}
