package com.digiwin.athena.abt.application.dto.migration.abt.groupteam;

import com.digiwin.athena.abt.application.dto.migration.abt.event.EventBaseDTO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * @Author wuzq
 * @Date 2023/6/25 17:18
 * @Description: PTM 待办创建后，创建 或 更新 IM任务群
 * @Version 1.0
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class PtmBacklogCreateGroupDTO extends EventBaseDTO {

    private Long backlogId;
    /**
     * 待办的目标租户
     */
    private String tenantId;
    private Long projectCardId;
    private Long projectId;

    /**
     * 相当于 bpmActivity.Id
     */
    private Long taskId;

    /**
     * 相当于 bpmActivityStep.id
     */
    private Long activityId;

    /**
     * 相当于 bpmActivityWorkitem.id
     */
    private Long workItemId;
    private String performerId;
    private String performerName;
    private Boolean closed;
    private LocalDateTime planEndTime;

    private String taskDefCode;
    private String taskDefName;

    private String taskName;

    private LocalDateTime createTime;
    private LocalDateTime closedTime;

    /**
     * 是否是合并的工作项
     */
    private Boolean merge;

    /**
     * 处理者类型0:默认;1:辅助执行者;2:跨租户
     */
    private Integer type;
    /**
     * 待办创建时，标记是否需要创建任务群
     */
    private Boolean canCreateTaskTeam;
}
