package com.digiwin.athena.abt.application.dto.migration.abt.groupteam;

import com.digiwin.athena.abt.application.dto.migration.abt.event.EventBaseDTO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;

/**
 * PTM 任务消息（相当于bpmActivitiy）
 * @author wzq
 * @date 2022-02-21
 */
@Data
public class PtmMqTaskMessageDTO extends EventBaseDTO {

    private MqData data;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class MqData{
        /**
         * 任务
         */
        private Task task;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class Task{
        private String id;
        private Long projectId;
        private Long projectCardId;
        private Integer state;
        private LocalDateTime planEndTime;
        private String taskDefName;
        private String taskName;
        private String taskDefCode;
        private LocalDateTime createTime;
        private LocalDateTime closedTime;
    }
}
