package com.digiwin.athena.abt.application.dto.migration.abt.groupteam;

import com.digiwin.athena.abt.application.dto.migration.abt.event.EventBaseDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmProjectDTO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @Author wuzq
 * @Date 2023/6/25 17:18
 * @Description: 项目卡关闭后，解散项目群
 * @Version 1.0
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class PtmProjectCardGroupDTO extends EventBaseDTO {
    private Long id;
    private String projectCode;
    private String projectName;
    private LocalDateTime startTime;
    private LocalDateTime endTime;
    private String personInCharge;
    private String personInChargeName;
    private Integer state;
    private Boolean completedReport;
    private String engine;
    private String targetId;
    private String targetName;
    private Long mainTaskId;

    /**
     * 增加PTM项目卡的自定义名称
     */
    private String name;
    /**
     * 包含的项目（子项目）数据
     */
    private List<PtmProjectDTO> project;

    /**
     * 业务关联人 UserId
     */
    private List<String> relatedUsers;

    /**
     * 业务主键
     */
    private String imBusinessKey;

    /**
     * 是否主项目
     */
    private Boolean hasMainTask;

    private String businessKey;

    private Long bpmProcessId;

}
