package com.digiwin.athena.abt.application.dto.migration.abt.groupteam;

import com.digiwin.athena.abt.application.dto.migration.abt.event.EventBaseDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmProjectDTO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @Author wuzq
 * @Date 2023/6/25 17:18
 * @Description: 项目卡关闭后，解散项目群
 * @Version 1.0
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class PtmProjectGroupDTO extends EventBaseDTO {
    /**
     * 包含的项目（子项目）数据
     */
    private PtmProjectDTO project;

    /**
     * 业务关联人 UserId
     */
    private List<String> relatedUsers;

}
