package com.digiwin.athena.abt.application.dto.migration.abt.inout;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @ClassName ImportStatisticsPO
 * @Description 导入统计数据
 * @Author zhuangli
 * @Date 2021/4/6 14:01
 * @Version 1.0
 **/
@Data
public class ImportStatistics {

    private Long id;
    private String masterId;
    private String activityId;
    private String activityName;
    private String userId;
    private String userJson;
    private String userToken;
    private String locale;
    private String actionId;
    private Integer succeededNum;
    private Integer processingNum;
    private Integer failedNum;
    // 错误个数
    private Integer errorNum;
    private String failedUrl;
    private Integer republished;
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;
    private List<ImportBatchRecord> importBatchRecords;
    private String routerKey;
    private String actionInfo;

    /**
     *  查询导入类型，0:业务数据录入，1:历史项目任务，2:任务，3:项目
     */
    private Integer type;

    /**
     *  导入模式 insert , update, insertOrUpdate
     */
    private String importModel;

    /**
     *  消耗时间
     */
    private String consumeTime;

    /**
     *  查询总数
     */
    private Integer queryPageTotal;

    /**
     * 导入文件url
     */
    private String fileUrl;

    /**
     * 文件唯一标识
     */
    private String fileUid;
}
