package com.digiwin.athena.abt.application.dto.migration.abt.inout;

import lombok.Data;

import java.time.LocalDateTime;

/**
 * @ClassName PersonalCenterMessage
 * @Description TODO
 * @Author zhuangli
 * @Date 2021/4/21 17:00
 * @Version 1.0
 **/
@Data
public class PersonalCenterMessage {

    private String gid;

    private String userId;

    private String langName;

    private String tenantId;

    /**
     * 消息类型，如：项目：TASK；任务：ACTIVITY
     */
    private String type;

    /**
     * 消息子类型，如：交期回复异常排除：checkConfirmDeliveryDateSolveProblem
     */
    private String subType;

    /**
     * 消息子类型所属类别，如：项目异常/逾期提醒
     */
    private String subTypeCategory;

    /**
     * 消息类别，多个消息类别以英文逗号隔开，如：NEW,EMERGENCY
     */
    private String category;

    /**
     * 重要性，0：不重要，1：重要
     */
    private Integer importance;

    private String source;

    /**
     * 消息状态，消息状态，0：未读，1：已读，3：过期，4：关闭
     */
    private Integer state;

    private String title;

    private Object content;

    /**
     * 消息发送时间
     */
    private LocalDateTime sendDate;

    /**
     * 消息生效时间
     */
    private LocalDateTime startTime;

    /**
     * 消息过期时间
     */
    private LocalDateTime endTime;

    private LocalDateTime createDate;

    private LocalDateTime modifyDate;

}
