package com.digiwin.athena.abt.application.dto.migration.abt.mechanism;

import com.digiwin.athena.abt.application.dto.migration.abt.action.*;
import lombok.Data;

import java.util.Date;
import java.util.List;
import java.util.Map;


@Data
public class Mechanism extends LanguageEntity {


    private String code;
    private String name;
    private String paradigmCode;
    private String paradigmName;
    private boolean paradigmChecked = false;
    //机制描述说明
    private String description;
    private String author;
    private Date createTime;

    //执行时的机制描述说明
    private String executeDescription;

    /*
    适用的场景/行业
     */
    private List<Tag> tags;


    //支持的erp产品 如E10 WFGP
    private String[] supportProducts;

    //需要的数据结构
    private FieldDescription requireDataFrame;

    //需要的参数
    private List<FieldDescription> paramDescription;

    //默认页面模板
    //参数值来源的运营单元
    private OperationUnit sourceOperationUnit;

    private boolean skipSimulate;

    //是否已设定
    private String defaultPageTemplate;

    //默认的实现类
    private String defaultPresent;


    //是否是组合机制
    private Boolean composite;

    private List<Mechanism> subMechanisms;

    private String  parentMechanismCode;

    private boolean hasSet;

    private List<Map> enhance;

    /**
     * 模拟结果回写接口定义
     */
    private List<ApiParamDescription> simulateResultWriteBack;

    /**
     * 是否跳过输出文档
     */
    private boolean skipOutputFile;

    /**
     * 机制的原理定义
     */
    private List<Principle> principles;

    private List<Map> extensions;

    //标记，作用，用于区分是走默认还是非默认解决兼容性问题
    private boolean needDefaultPrinciple;

    private Boolean originalNoParam;

    private String mergeVersion;
}
