package com.digiwin.athena.abt.application.dto.migration.abt.mq;

import com.digiwin.athena.abt.application.dto.migration.abt.event.EventListenerDTO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;

/**
 * PTM 待办 消息类型
 * @author zhujg
 * @date 2022-01-20
 */
@Data
public class PtmBacklogMessageDTO extends EventListenerDTO {

    private MqData data;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class MqData{
        /**
         * 待办
         */
        private Backlog backlog;

        /**
         * 导致任务卡变更的原因，转派：REASSIGN  交接：HANDOVER
         */
        private String changeType;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class Backlog {

        private String name;

        private Long backlogId;
        /**
         * 待办的目标租户
         */
        private String tenantId;
        private Long projectCardId;
        private Long projectId;

        /**
         * 相当于 bpmActivity.Id
         */
        private Long taskId;

        /**
         * 相当于 bpmActivityStep.id
         */
        private Long activityId;

        /**
         * 相当于 bpmActivityWorkitem.id
         */
        private Long workItemId;
        private String performerId;
        private String performerName;
        private Boolean closed;
        private LocalDateTime planEndTime;

        private String taskDefCode;
        private String taskDefName;

        private String taskName;

        private LocalDateTime createTime;
        private LocalDateTime closedTime;

        /**
         * 是否是合并的工作项
         */
        private Boolean merge;

        /**
         * 处理者类型0:默认;1:辅助执行者;2:跨租户
         */
        private Integer type;

        /**
         * 任务卡是否隐藏
         */
        private Boolean hidden;

    }


}
