package com.digiwin.athena.abt.application.dto.migration.abt.mq;

import com.digiwin.athena.abt.application.dto.migration.abt.event.EventListenerDTO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Map;

/**
 * PTM 数据一致性消息
 * @author zhujg
 * @date 2022-04-06
 */
@Data
public class PtmDataConsistencyMessageDTO extends EventListenerDTO {

    private MqData data;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class MqData{
        /**
         *  是否最小化
         */
        private Boolean minSplit;
        /**
         *  ptm推送数据一致性结构调整 老的是非数组 最小化是数组
         */
        private List<WorkItem> workItem;
        private Project project;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class WorkItem{
        private Long backlogId;
        private Long activityId;
        private Map data;
        private Long id;
        private Long projectCardId;
        private Long projectId;
        private Long taskId;
        private Integer state;
        private Integer subState;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class Project{
        private Map data;
        private Long id;
        private Long projectCardId;
    }
}
