package com.digiwin.athena.abt.application.dto.migration.abt.mq;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * PTM 项目卡(主项目) data
 * @author zhujg
 * @date 2022-01-21
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class PtmProjectCardDataDTO {
    /**
     * 项目卡数据
     */
    private PtmProjectCardDTO projectCard;

    /**
     * 业务关联人 UserId
     */
    private List<String> relatedUsers;

    /**
     * 项目业务主键
     */
    private String imBusinessKey;

    /**
     * 包含的项目（子项目）数据
     */
    private List<PtmProjectDTO> project;

    /**
     * 导致任务卡变更的原因，转派：REASSIGN  交接：HANDOVER
     */
    private String changeType;
}
