package com.digiwin.athena.abt.application.dto.migration.abt.mq;

import com.digiwin.athena.abt.application.dto.migration.abt.event.EventListenerDTO;
import com.digiwin.athena.appcore.domain.LanguageMark;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.List;

@Data
public class PtmWorkItemMessageDTO extends EventListenerDTO {

    private MqData data;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class MqData{
        /**
         * 工作项
         */
        private WorkItem workItem;
    }

    /**
     *  工作项详情
     */
    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class WorkItem{
        /**
         * 项目code
         */
        private String projectCode;
        /**
         * 任务code
         */
        private String taskCode;
        /**
         * 执行人id
         */
        private String performerId;
        /**
         * 执行人姓名
         */
        private String performerName;
        /**
         * 任务卡待办id
         */
        private Long backlogId;
        /**
         * 工作项id
         */
        private Long workItemId;
        /**
         * 任务名称
         */
        @LanguageMark
        private String taskName;
        /**
         * 项目名称
         */
        private String projectName;
        /**
         * 租户
         */
        private String tenantId;
        /**
         * 任务预完日
         */
        private LocalDateTime planEndTime;
        /**
         * 来源（asa-来源于帮帮我娜）
         */
        private String source;
        /**
         * 通知方式
         */
        private List<NoticeInfo> notices;
        /**
         * 项目当责者
         */
        private String personInCharge;
        /**
         * 项目当责者名称
         */
        private String personInChargeName;

    }

    /**
     * 通知信息
     */
    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class NoticeInfo{
        private String type;
    }

}
